<?php

namespace RtclPro\Controllers\Hooks;

use Rtcl\Helpers\Functions;
use RtclPro\Helpers\Options;

class AdminSettingsHook {


	public static function init() {
		add_filter( 'rtcl_general_settings_options', [ __CLASS__, 'general_settings_pro_feature' ] );
		add_filter( 'rtcl_archive_listing_settings_options', [ __CLASS__, 'archive_listing_settings_pro_feature' ] );
		add_filter( 'rtcl_single_listing_settings_options', [ __CLASS__, 'single_listing_settings_pro_feature' ] );
		add_filter( 'rtcl_general_listing_label_settings_options', [ __CLASS__, 'listing_label_settings_pro_feature' ] );
		add_filter( 'rtcl_account_settings_options', [ __CLASS__, 'account_settings_pro_feature' ] );
		add_filter( 'rtcl_style_settings_options', [ __CLASS__, 'style_settings_pro_feature' ] );
		add_filter( 'rtcl_moderation_settings_options', [ __CLASS__, 'moderation_settings_pro_feature' ] );
		add_filter( 'rtcl_tools_settings_options', [ __CLASS__, 'tools_settings_pro_feature' ] );
		add_filter( 'rtcl_advanced_settings_options', [ __CLASS__, 'advanced_settings_pro_feature' ] );
		add_filter( 'rtcl_get_listing_display_options', [ __CLASS__, 'listing_display_options' ] );
		add_filter( 'rtcl_get_listing_detail_page_display_options', [ __CLASS__, 'listing_display_options' ] );
		add_filter( 'rtcl_register_settings_group', [ __CLASS__, 'add_chat_tab' ] );
		add_filter( 'rtcl_settings_option_fields', [ __CLASS__, 'add_chat_settings_options' ], 10, 2 );
		add_filter( 'rtcl_payment_settings_options', [ __CLASS__, 'payment_subscription_options' ], 10, 2 );
	}

	public static function add_chat_settings_options( $fields, $active_tab ) {
		if ( 'chat' === $active_tab ) {
			$fields = Options::chat_admin_settings();
		}

		return $fields;
	}

	public static function add_chat_tab( $tabs ) {
		$position = array_search( 'misc', array_keys( $tabs ) );
		if ( $position > - 1 ) {
			$newOptions = [
				'chat' => [
					'title'  => esc_html__( 'Chat', 'classified-listing-pro' ),
					'subtab' => []
				]
			];
			Functions::array_insert( $tabs, $position, $newOptions );
		}

		return $tabs;
	}

	public static function listing_display_options( $options ) {
		$options['popular'] = esc_html__( 'Popular Label', 'classified-listing-pro' );
		$options['top']     = esc_html__( 'Top Label', 'classified-listing-pro' );
		$options['bump_up'] = esc_html__( 'Bump Up Label', 'classified-listing-pro' );

		return $options;
	}

	public static function payment_subscription_options( $options ) {
		$newOptions = [
			'subscription' => [
				'title'       => esc_html__( 'Enable Subscription', 'classified-listing-pro' ),
				'type'        => 'checkbox',
				'label'       => esc_html__( 'Subscription for membership', 'classified-listing-pro' ),
				'description' => __( 'Recurring payment with auto renew <span style="color: red">(Available only with Stripe & AuthorizeNet)</span>',
					'classified-listing-pro' ),
				'default'     => 'no'
			]
		];

		return self::append_options( 'billing_address_disabled', $options, $newOptions );
	}

	public static function advanced_settings_pro_feature( $options ) {
		$newOptions = [
			'myaccount_chat_endpoint' => [
				'title'   => esc_html__( 'Chat', 'classified-listing-pro' ),
				'type'    => 'text',
				'default' => 'chat',
			],
			'myaccount_verify'        => [
				'title'   => esc_html__( 'Account Verify', 'classified-listing-pro' ),
				'type'    => 'text',
				'default' => 'verify',
			],
		];
		$newOptions = apply_filters( 'rtcl_pro_advanced__settings_pro_feature', $newOptions );

		return self::append_options( 'myaccount_favourites_endpoint', $options, $newOptions );
	}

	public static function tools_settings_pro_feature( $options ) {
		$apiKey = get_option( 'rtcl_rest_api_key', null );

		if ( $apiKey ) {
			$rest_api_key_html = sprintf( '<div><span class="rtcl-rest-api-key">%s</span>%s</div> %s',
				$apiKey,
				! wp_is_uuid( $apiKey ) ? '<span class="rtcl-rest-api-key-invalid" style="color: red">%s Key is not validate.</span>' : '',
				sprintf(
					'<a href="%s" onclick="return confirm(%s)">%s</a>',
					add_query_arg(
						[
							'_wpnonce'                   => wp_create_nonce( 'rtcl_generate_rest_api_key' ),
							'rtcl_generate_rest_api_key' => 1,
						],
						admin_url( 'admin.php?page=rtcl-settings&tab=tools' )
					),
					esc_html__( "'Are you sure want to regenerate REST API key?'", 'classified-listing-pro' ),
					esc_html__( 'Regenerate Rest API key', 'classified-listing-pro' )
				)
			);

		} else {
			$rest_api_key_html = sprintf(
				'<a href="%s">%s</a>',
				add_query_arg(
					[
						'_wpnonce'                   => wp_create_nonce( 'rtcl_generate_rest_api_key' ),
						'rtcl_generate_rest_api_key' => 1,
					],
					admin_url( 'admin.php?page=rtcl-settings&tab=tools' )
				),
				esc_html__( 'Create Rest API key', 'classified-listing-pro' )
			);
		}
		$newOptions = [
			'app_section'    => [
				'title' => esc_html__( 'App Management', 'classified-listing-pro' ),
				'type'  => 'section',
			],
			'allow_rest_api' => [
				'title'       => esc_html__( 'Allow REST API', 'classified-listing-pro' ),
				'type'        => 'checkbox',
				'description' => esc_html__( 'Allow to handle data to app.', 'classified-listing-pro' ),
			],
			'rest_api_key'   => [
				'title'       => esc_html__( 'REST API Key', 'classified-listing-pro' ),
				'type'        => 'html',
				'html'        => $rest_api_key_html,
				'description' => '<span style="color: red">'
				                 . esc_html__( 'This is one time generated key. Do not recreate this key. if you regenerate then you need to change the key from your application where you are currently using.',
						'classified-listing-pro' ) . '</span>',
			],
		];
		$newOptions = apply_filters( 'rtcl_pro_tools_settings_pro_feature', $newOptions );

		return self::append_options( 'delete_all_data', $options, $newOptions );
	}

	public static function moderation_settings_pro_feature( $options ) {
		$newOptions = [
			'required_gallery_image' => [
				'title' => esc_html__( 'Required Gallery Image', 'classified-listing-pro' ),
				'type'  => 'checkbox',
				'label' => esc_html__( 'Make gallery image mandatory.', 'classified-listing-pro' ),
			],
		];

		$newOptions = apply_filters( 'rtcl_pro_moderation_settings_pro_feature_1', $newOptions );

		return self::append_options( 'enable_social_profiles', $options, $newOptions );
	}

	public static function style_settings_pro_feature( $options ) {
		$newOptions = [
			'top'          => [
				'title' => esc_html__( 'Top Label Background Color', 'classified-listing-pro' ),
				'type'  => 'color',
			],
			'top_text'     => [
				'title' => esc_html__( 'Top Label Text Color', 'classified-listing-pro' ),
				'type'  => 'color',
			],
			'popular'      => [
				'title' => esc_html__( 'Popular Label Background Color', 'classified-listing-pro' ),
				'type'  => 'color',
			],
			'popular_text' => [
				'title' => esc_html__( 'Popular Label Text Color', 'classified-listing-pro' ),
				'type'  => 'color',
			],
			'bump_up'      => [
				'title' => esc_html__( 'BumpUp Label Background Color', 'classified-listing-pro' ),
				'type'  => 'color',
			],
			'bump_up_text' => [
				'title' => esc_html__( 'BumpUp Text Color', 'classified-listing-pro' ),
				'type'  => 'color',
			],
		];
		$newOptions = apply_filters( 'rtcl_pro_style_settings_pro_feature', $newOptions );

		return self::append_options( 'feature_text', $options, $newOptions );
	}

	public static function account_settings_pro_feature( $options ) {
		$newOptions = [
			'allowed_core_permission_roles' => [
				'title'       => esc_html__( 'Admin Menu Access Role', 'classified-listing-pro' ),
				'type'        => 'multi_checkbox',
				'options'     => Functions::get_user_roles( '', [ 'administrator', 'rtcl_manager' ] ),
				'description' => wp_kses(
					__( 'Allowed all Classified Listing Admin Menu access to a user role as like Administrator. [<span style="color: red;">NOT RECOMMENDED</span>]',
						'classified-listing-pro' ),
					[
						'span' => [
							'style' => [ 'color' ],
						],
					]
				),
			],
			'enable_post_for_unregister'    => [
				'title'       => esc_html__( 'Allow Post for Unregister User', 'classified-listing-pro' ),
				'type'        => 'checkbox',
				'description' => esc_html__( 'Allow visitor to create a post and account will create automatically', 'classified-listing-pro' ),
			],
			'user_verification'             => [
				'title'       => esc_html__( 'User Verification', 'classified-listing-pro' ),
				'type'        => 'checkbox',
				'description' => esc_html__( 'User Registration will be pending and a verification email will send to the user email.',
					'classified-listing-pro' ),
			],
			'verify_max_resend_allowed'     => [
				'title'             => esc_html__( 'Max Re-send attempts', 'classified-listing-pro' ),
				'type'              => 'number',
				'default'           => 5,
				'css'               => 'width:50px',
				'wrapper_class'     => Functions::get_option_item( 'rtcl_account_settings', 'user_verification', null, 'checkbox' ) ? '' : 'hidden',
				'custom_attributes' => [
					'step' => '1',
					'min'  => '1',
					'max'  => '15',
				],
				'description'       => esc_html__( 'Max number of re-send requests a user can make, more than that, his account will be locked.',
					'classified-listing-pro' ),
			],
		];
		$newOptions = apply_filters( 'rtcl_pro_account_settings_pro_feature', $newOptions );

		return self::append_options( 'user_role', $options, $newOptions );
	}

	public static function listing_label_settings_pro_feature( $options ) {
		$newOptions = [
			'popular_listing_label'     => [
				'title'       => esc_html__( 'Popular Listings Label', 'classified-listing-pro' ),
				'type'        => 'text',
				'default'     => esc_html__( 'Popular', 'classified-listing-pro' ),
				'description' => esc_html__( 'Enter the text you want to use inside the "Popular" tag.', 'classified-listing-pro' ),
			],
			'popular_listing_threshold' => [
				'title'       => esc_html__( 'Popular Listing Threshold (in views count)', 'classified-listing-pro' ),
				'type'        => 'number',
				'default'     => 1000,
				'description' => esc_html__(
					'Enter the minimum number of views required for a listing to be tagged as "Popular".',
					'classified-listing-pro'
				),
			],
			'listing_top_label'         => [
				'title'       => esc_html__( 'Top Listings Label', 'classified-listing-pro' ),
				'type'        => 'text',
				'default'     => esc_html__( 'Top', 'classified-listing-pro' ),
				'description' => esc_html__( 'Enter the text you want to use inside the "Top" tag.', 'classified-listing-pro' ),
			],
			'listing_bump_up_label'     => [
				'title'       => esc_html__( 'Bump Up Listings Label', 'classified-listing-pro' ),
				'type'        => 'text',
				'default'     => esc_html__( 'Bump Up', 'classified-listing-pro' ),
				'description' => esc_html__( 'Enter the text you want to use inside the "Bump Up" tag.', 'classified-listing-pro' ),
			],
		];

		$newOptions = apply_filters( 'rtcl_pro_listing_label_settings_pro_feature_1', $newOptions );

		return self::append_options( 'listing_featured_label', $options, $newOptions );
	}

	public static function single_listing_settings_pro_feature( $options ) {
		$newOptions = [
			'enable_review_rating'     => [
				'title' => esc_html__( 'Enable Review Rating', 'classified-listing-pro' ),
				'type'  => 'checkbox',
				'label' => esc_html__( 'Allow visitors to make review rating.', 'classified-listing-pro' ),
			],
			'enable_update_rating'     => [
				'title' => esc_html__( 'Enable Update Rating', 'classified-listing-pro' ),
				'type'  => 'checkbox',
				'label' => esc_html__( 'If same user try to add duplicate post than allow it to update previous one.', 'classified-listing-pro' ),
			],
			'registered_only'          => [
				'title'   => esc_html__( 'Registered User Only', 'classified-listing-pro' ),
				'type'    => 'multi_checkbox',
				'options' => Options::get_registered_only_options(),
			],
			'disable_single_listing'   => [
				'title' => esc_html__( 'Disable Single Listing View', 'classified-listing-pro' ),
				'type'  => 'checkbox',
				'label' => esc_html__( 'Disable listing details page.', 'classified-listing-pro' ),
			],
			'single_listing_logged_in' => [
				'title'      => esc_html__( 'Show Single Page only for Logged-in Users', 'classified-listing-pro' ),
				'type'       => 'checkbox',
				'label'      => esc_html__( 'Disable listing details page.', 'classified-listing-pro' ),
				'dependency' => [
					'rules' => [
						'#rtcl_single_listing_settings-disable_single_listing' => [
							'type'  => '!=',
							'value' => 'yes'
						]
					]
				]
			],
		];

		$newOptions = apply_filters( 'rtcl_pro_single_listing_settings_pro_feature_1', $newOptions );
		$options    = self::append_options( 'has_comment_form', $options, $newOptions );

		$newOptions = [
			'disable_gallery_zoom'       => [
				'title' => esc_html__( 'Disable Gallery Zoom', 'classified-listing-pro' ),
				'type'  => 'checkbox',
				'label' => esc_html__( 'Disable', 'classified-listing-pro' ),
			],
			'disable_gallery_photoswipe' => [
				'title'       => esc_html__( 'Disable Gallery Lightbox', 'classified-listing-pro' ),
				'type'        => 'checkbox',
				'label'       => esc_html__( 'Disable', 'classified-listing-pro' ),
				'description' => esc_html__( 'Disable gallery lightbox (PopUp lightbox Gallery)', 'classified-listing-pro' ),
			]
		];

		$newOptions = apply_filters( 'rtcl_pro_single_listing_settings_pro_feature_2', $newOptions );

		return self::append_options( 'disable_gallery_slider', $options, $newOptions );
	}

	public static function archive_listing_settings_pro_feature( $options ) {
		$newOptions = [
			'listing_enable_top_listing' => [
				'title'   => esc_html__( 'Enable Top Listing at Listing Page', 'classified-listing-pro' ),
				'type'    => 'checkbox',
				'default' => 'yes',
				'label'   => esc_html__( 'Enable top listing', 'classified-listing-pro' ),
			],
			'listing_top_per_page'       => [
				'title'       => esc_html__( 'Top Listing Number to Display', 'classified-listing-pro' ),
				'type'        => 'number',
				'default'     => 2,
				'description' => esc_html__( 'Enter number of top listing to display at listing page', 'classified-listing-pro' ),
			],
		];

		$newOptions = apply_filters( 'rtcl_pro_archive_listing_settings_pro_feature', $newOptions );

		return self::append_options( 'listings_per_row', $options, $newOptions );
	}

	public static function general_settings_pro_feature( $options ) {
		$newOptions = [
			'enable_quick_view'   => [
				'title' => esc_html__( 'Enable Quick View', 'classified-listing-pro' ),
				'type'  => 'checkbox',
				'label' => esc_html__( 'Enable Quick view.', 'classified-listing-pro' ),
			],
			'enable_compare'      => [
				'title' => esc_html__( 'Enable Compare', 'classified-listing-pro' ),
				'type'  => 'checkbox',
				'label' => esc_html__( 'Enable compare', 'classified-listing-pro' ),
			],
			'compare_limit'       => [
				'title'       => esc_html__( 'Compare Limit', 'classified-listing-pro' ),
				'type'        => 'number',
				'default'     => 3,
				'css'         => 'width:50px',
				'description' => esc_html__( 'Maximum number of listings to compare', 'classified-listing-pro' ),
			],
			'enable_mark_as_sold' => [
				'title' => esc_html__( 'Enable Mark as Sold', 'classified-listing-pro' ),
				'type'  => 'checkbox',
				'label' => esc_html__( 'Enable Mark as Sold', 'classified-listing-pro' ),
			]
		];

		$newOptions = apply_filters( 'rtcl_pro_general_settings_pro_feature', $newOptions );

		return self::append_options( 'delete_expired_listings', $options, $newOptions );
	}

	/**
	 * @param       $target_item
	 * @param       $options
	 * @param array $newOptions
	 *
	 * @return array
	 */
	private static function append_options( $target_item, $options, array $newOptions ) {
		$position = array_search( $target_item, array_keys( $options ) );
		if ( $position > - 1 ) {
			Functions::array_insert( $options, $position, $newOptions );
		} else {
			array_unshift(
				$newOptions,
				[
					$target_item . '_pro_section' => [
						'title'       => esc_html__( 'Pro settings', 'classified-listing-pro' ),
						'type'        => 'title',
						'description' => '',
					],
				]
			);

			$options = array_merge( $options, $newOptions );
		}

		return $options;
	}
}
