<?php
/**
 * View switcher
 *
 * @version     1.5.5
 *
 * @var array  $views
 * @var string $current_view
 * @var string $default_view
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
if ( empty( $views ) ) {
	return;
}
?>
<div class="rtcl-view-switcher">
	<?php
	foreach ( $views as $value => $label ) {
		$active = $current_view === $value ? ' active' : '';
		$thIcon = $value === 'grid' ? "large" : $value;
		?>
		<a class="rtcl-view-trigger<?php echo esc_attr( $active ); ?>" data-type="<?php echo esc_attr( $value ); ?>"
		   href="<?php echo esc_url( add_query_arg( 'view', $value ) ) ?>">
			<?php if ( 'grid' === $value ): ?>
				<span class="v-icon">
                    <svg width="20" height="20" viewBox="0 0 20 20" fill="currentColor"
						 xmlns="http://www.w3.org/2000/svg">
                      <path
						  d="M0 2.14286C0 1.57454 0.225765 1.02949 0.627628 0.627628C1.02949 0.225765 1.57454 0 2.14286 0H6.42857C6.99689 0 7.54194 0.225765 7.9438 0.627628C8.34566 1.02949 8.57143 1.57454 8.57143 2.14286V6.42857C8.57143 6.99689 8.34566 7.54194 7.9438 7.9438C7.54194 8.34566 6.99689 8.57143 6.42857 8.57143H2.14286C1.57454 8.57143 1.02949 8.34566 0.627628 7.9438C0.225765 7.54194 0 6.99689 0 6.42857V2.14286ZM2.14286 1.42857C1.95342 1.42857 1.77174 1.50383 1.63778 1.63778C1.50383 1.77174 1.42857 1.95342 1.42857 2.14286V6.42857C1.42857 6.61801 1.50383 6.79969 1.63778 6.93365C1.77174 7.0676 1.95342 7.14286 2.14286 7.14286H6.42857C6.61801 7.14286 6.79969 7.0676 6.93365 6.93365C7.0676 6.79969 7.14286 6.61801 7.14286 6.42857V2.14286C7.14286 1.95342 7.0676 1.77174 6.93365 1.63778C6.79969 1.50383 6.61801 1.42857 6.42857 1.42857H2.14286ZM11.4286 2.14286C11.4286 1.57454 11.6543 1.02949 12.0562 0.627628C12.4581 0.225765 13.0031 0 13.5714 0H17.8571C18.4255 0 18.9705 0.225765 19.3724 0.627628C19.7742 1.02949 20 1.57454 20 2.14286V6.42857C20 6.99689 19.7742 7.54194 19.3724 7.9438C18.9705 8.34566 18.4255 8.57143 17.8571 8.57143H13.5714C13.0031 8.57143 12.4581 8.34566 12.0562 7.9438C11.6543 7.54194 11.4286 6.99689 11.4286 6.42857V2.14286ZM13.5714 1.42857C13.382 1.42857 13.2003 1.50383 13.0664 1.63778C12.9324 1.77174 12.8571 1.95342 12.8571 2.14286V6.42857C12.8571 6.61801 12.9324 6.79969 13.0664 6.93365C13.2003 7.0676 13.382 7.14286 13.5714 7.14286H17.8571C18.0466 7.14286 18.2283 7.0676 18.3622 6.93365C18.4962 6.79969 18.5714 6.61801 18.5714 6.42857V2.14286C18.5714 1.95342 18.4962 1.77174 18.3622 1.63778C18.2283 1.50383 18.0466 1.42857 17.8571 1.42857H13.5714ZM0 13.5714C0 13.0031 0.225765 12.4581 0.627628 12.0562C1.02949 11.6543 1.57454 11.4286 2.14286 11.4286H6.42857C6.99689 11.4286 7.54194 11.6543 7.9438 12.0562C8.34566 12.4581 8.57143 13.0031 8.57143 13.5714V17.8571C8.57143 18.4255 8.34566 18.9705 7.9438 19.3724C7.54194 19.7742 6.99689 20 6.42857 20H2.14286C1.57454 20 1.02949 19.7742 0.627628 19.3724C0.225765 18.9705 0 18.4255 0 17.8571V13.5714ZM2.14286 12.8571C1.95342 12.8571 1.77174 12.9324 1.63778 13.0664C1.50383 13.2003 1.42857 13.382 1.42857 13.5714V17.8571C1.42857 18.0466 1.50383 18.2283 1.63778 18.3622C1.77174 18.4962 1.95342 18.5714 2.14286 18.5714H6.42857C6.61801 18.5714 6.79969 18.4962 6.93365 18.3622C7.0676 18.2283 7.14286 18.0466 7.14286 17.8571V13.5714C7.14286 13.382 7.0676 13.2003 6.93365 13.0664C6.79969 12.9324 6.61801 12.8571 6.42857 12.8571H2.14286ZM11.4286 13.5714C11.4286 13.0031 11.6543 12.4581 12.0562 12.0562C12.4581 11.6543 13.0031 11.4286 13.5714 11.4286H17.8571C18.4255 11.4286 18.9705 11.6543 19.3724 12.0562C19.7742 12.4581 20 13.0031 20 13.5714V17.8571C20 18.4255 19.7742 18.9705 19.3724 19.3724C18.9705 19.7742 18.4255 20 17.8571 20H13.5714C13.0031 20 12.4581 19.7742 12.0562 19.3724C11.6543 18.9705 11.4286 18.4255 11.4286 17.8571V13.5714ZM13.5714 12.8571C13.382 12.8571 13.2003 12.9324 13.0664 13.0664C12.9324 13.2003 12.8571 13.382 12.8571 13.5714V17.8571C12.8571 18.0466 12.9324 18.2283 13.0664 18.3622C13.2003 18.4962 13.382 18.5714 13.5714 18.5714H17.8571C18.0466 18.5714 18.2283 18.4962 18.3622 18.3622C18.4962 18.2283 18.5714 18.0466 18.5714 17.8571V13.5714C18.5714 13.382 18.4962 13.2003 18.3622 13.0664C18.2283 12.9324 18.0466 12.8571 17.8571 12.8571H13.5714Z"></path>
                    </svg>
                </span>
			<?php else: ?>
				<span class="v-icon">
                    <svg width="20" height="20" viewBox="0 0 21 18" fill="currentColor"
						 xmlns="http://www.w3.org/2000/svg">
                      <path
						  d="M10.5 3H21V4.5H10.5V3ZM10.5 13.5H21V15H10.5V13.5ZM6 7.5H1.5C1.1023 7.4996 0.720997 7.34144 0.439778 7.06022C0.15856 6.779 0.000397108 6.3977 0 6V1.5C0.000397108 1.1023 0.15856 0.720997 0.439778 0.439779C0.720997 0.15856 1.1023 0.000397108 1.5 0H6C6.3977 0.000397108 6.779 0.15856 7.06022 0.439779C7.34144 0.720997 7.4996 1.1023 7.5 1.5V6C7.4996 6.3977 7.34144 6.779 7.06022 7.06022C6.779 7.34144 6.3977 7.4996 6 7.5ZM1.5 1.5V6H6.00075L6 1.5H1.5ZM6 18H1.5C1.1023 17.9996 0.720997 17.8414 0.439778 17.5602C0.15856 17.279 0.000397108 16.8977 0 16.5V12C0.000397108 11.6023 0.15856 11.221 0.439778 10.9398C0.720997 10.6586 1.1023 10.5004 1.5 10.5H6C6.3977 10.5004 6.779 10.6586 7.06022 10.9398C7.34144 11.221 7.4996 11.6023 7.5 12V16.5C7.4996 16.8977 7.34144 17.279 7.06022 17.5602C6.779 17.8414 6.3977 17.9996 6 18ZM1.5 12V16.5H6.00075L6 12H1.5Z"></path>
                    </svg>
                </span>
			<?php endif; ?>
		</a>
	<?php } ?>
</div>
