<?php

namespace RtclStore\Controllers\Hooks;


use Rtcl\Helpers\Functions;
use Rtcl\Helpers\Functions as RtclFunctions;
use Rtcl\Helpers\Link;
use Rtcl\Models\Listing;
use Rtcl\Shortcodes\Checkout;
use RtclPro\Helpers\Fns;
use RtclStore\Helpers\Functions as StoreFunctions;
use RtclStore\Models\Membership;
use RtclStore\Models\Store;
use RtclStore\Resources\Options as StoreOptions;
use WP_User;

class TemplateHooks {
	static function init() {
		add_filter( 'rtcl_is_rtcl', [ __CLASS__, 'store_is_rtcl' ] );
		add_filter( 'post_class', [ __CLASS__, 'store_post_class' ], 20, 3 );
		add_action( 'the_content', [ __CLASS__, 'store_content_restriction' ] );

		add_action( 'rtcl_store_sidebar', [ __CLASS__, 'get_store_sidebar' ], 10 );

		add_action( 'rtcl_single_store_information', [ __CLASS__, 'store_hours' ], 10 );
		if ( ! Fns::registered_user_only( 'store_contact' ) || Fns::registered_user_only( 'store_contact' ) && is_user_logged_in() ) {
			add_action( 'rtcl_single_store_information', [ __CLASS__, 'store_address' ], 20 );
			add_action( 'rtcl_single_store_information', [ __CLASS__, 'store_phone' ], 30 );
			add_action( 'rtcl_single_store_information', [ __CLASS__, 'store_website' ], 35 );
			add_action( 'rtcl_single_store_information', [ __CLASS__, 'store_social_media' ], 40 );
			add_action( 'rtcl_single_store_information', [ __CLASS__, 'store_social_email' ], 50 );
		} else {
			add_action( 'rtcl_single_store_information', [ __CLASS__, 'add_user_login_link' ], 20 );
		}
		add_action( 'rtcl_single_store_detail_modal', [ __CLASS__, 'store_detail_modal' ] );

		add_action( 'rtcl_single_store_expired_content', [ __CLASS__, 'single_store_expired_content' ] );


		// Store loop
		add_action( 'rtcl_before_store_loop', [ __CLASS__, 'store_actions' ], 20 );
		add_action( 'rtcl_store_loop_action', [ __CLASS__, 'result_count' ], 10 );
		add_action( 'rtcl_store_loop_action', [ __CLASS__, 'catalog_ordering' ], 20 );
		add_action( 'rtcl_no_stores_found', [ __CLASS__, 'no_stores_found' ] );

		add_action( 'rtcl_before_store_loop_item', [ __CLASS__, 'open_store_link' ], 10 );
		add_action( 'rtcl_store_loop_item_thumbnail', [ __CLASS__, 'store_thumbnail' ] );

		add_action( 'rtcl_store_loop_item', [ __CLASS__, 'loop_item_content_start' ], 5 );
		add_action( 'rtcl_store_loop_item', [ __CLASS__, 'loop_item_store_title' ], 10 );
		add_action( 'rtcl_store_loop_item', [ __CLASS__, 'store_meta' ], 20 );
		add_action( 'rtcl_store_loop_item', [ __CLASS__, 'loop_item_content_end' ], 100 );

		add_action( 'rtcl_after_store_loop_item', [ __CLASS__, 'close_store_link' ], 5 );

		add_action( 'rtcl_after_store_loop', [ __CLASS__, 'pagination' ], 10 );

		add_action( 'rtcl_checkout_form_start', [ __CLASS__, 'add_membership_pricing_options_at_checkout_form' ], 10 );
		if ( StoreFunctions::is_enable_store_manager() ) {
			add_action( 'rtcl_account_dashboard', [ __CLASS__, 'store_manager_action' ], 40 );
		}
		if ( StoreFunctions::is_membership_enabled() ) {
			add_action( 'rtcl_account_dashboard_report', [ __CLASS__, 'membership_statistic_report' ], 10 );
		}
		add_action( 'rtcl_checkout_membership_endpoint', [ __CLASS__, 'membership_endpoint_content' ], 10, 2 );
		add_action( 'rtcl_account_store_endpoint', [ __CLASS__, 'account_store_endpoint' ] );
		add_action( 'rtcl_add_user_information', [ __CLASS__, 'add_store_link_to_user_information' ] );

		add_action( 'rtcl_before_checkout_form', [ __CLASS__, 'add_membership_promotions_heading' ], 20, 2 );
		add_action( 'rtcl_before_checkout_form', [ __CLASS__, 'add_membership_promotions_from' ], 30, 2 );
		add_action( 'rtcl_before_checkout_form', [ __CLASS__, 'add_checkout_from_heading' ], 40, 2 );
		add_action( 'rtcl_membership_promotion_form', [ __CLASS__, 'add_membership_promotions' ], 10, 3 );
		add_action( 'rtcl_membership_promotion_form_submit_button', [
			__CLASS__,
			'membership_promotion_form_submit_button'
		], 10 );
		add_action( 'rtcl_membership_promotion_form_end', [ __CLASS__, 'add_membership_promotions_hidden_field' ], 50 );

		add_action( 'rtcl_store_contact_form', [ __CLASS__, 'g_recaptcha_v2_placeholder' ] );
		// user badges
		add_action( 'rtcl_listing_author_badges', [ __CLASS__, 'add_membership_badge' ], 10 );
		add_action( 'rtcl_listing_author_badges', [ __CLASS__, 'add_store_owner_badge' ], 20 );
	}

	public static function add_store_owner_badge( $listing ) {
		if ( is_a( $listing, Listing::class ) && $listing->can_show_store_owner_badge() ) {
			$store = StoreFunctions::get_user_store( $listing->get_owner_id() );
			if ( $store ) {
				?>
                <span class="rtcl-tooltip-wrapper">
                    <svg width="20" height="21" viewBox="0 0 20 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <g clip-path="url(#clip0_338_318)">
                            <path d="M18.6328 1.45573C18.5884 1.32307 18.5034 1.20771 18.3898 1.12594C18.2763 1.04417 18.14 1.00012 18 1H2.00003C1.86012 1.00014 1.72378 1.0442 1.61025 1.12597C1.49671 1.20773 1.41171 1.32308 1.36724 1.45573L0.0339018 5.45573C0.0115914 5.52383 0.000161877 5.59501 3.49659e-05 5.66667C-0.00234365 6.19439 0.116665 6.7156 0.347862 7.18999C0.579058 7.66438 0.916249 8.07925 1.33337 8.40253V17.6667C1.33302 17.9294 1.38451 18.1896 1.48489 18.4324C1.58528 18.6753 1.73258 18.8959 1.91837 19.0817C2.10416 19.2675 2.32478 19.4148 2.56759 19.5151C2.8104 19.6155 3.07063 19.667 3.33337 19.6667H6.48003C7.45134 20.5258 8.70331 21 10 21C11.2968 21 12.5487 20.5258 13.52 19.6667H16.6667C16.9294 19.667 17.1897 19.6155 17.4325 19.5151C17.6753 19.4148 17.8959 19.2675 18.0817 19.0817C18.2675 18.8959 18.4148 18.6753 18.5152 18.4324C18.6156 18.1896 18.6671 17.9294 18.6667 17.6667V8.40213C19.0837 8.07888 19.4209 7.66407 19.6521 7.18975C19.8833 6.71544 20.0023 6.19432 20 5.66667C19.9999 5.59501 19.9885 5.52383 19.9662 5.45573L18.6328 1.45573ZM2.48004 2.33333H17.52L18.6646 5.76827C18.6582 6.11501 18.5649 6.45462 18.3933 6.75599C18.2217 7.05736 17.9772 7.31088 17.6823 7.49333H17.68C17.4707 7.60514 17.2374 7.66461 17 7.66667C16.5156 7.61808 16.0696 7.38132 15.7579 7.00731C15.4463 6.6333 15.2938 6.15191 15.3334 5.66667C15.3334 5.48986 15.2631 5.32029 15.1381 5.19526C15.0131 5.07024 14.8435 5 14.6667 5C14.4899 5 14.3203 5.07024 14.1953 5.19526C14.0703 5.32029 14 5.48986 14 5.66667C14.0396 6.15191 13.8871 6.6333 13.5755 7.00731C13.2638 7.38132 12.8178 7.61808 12.3334 7.66667C11.8489 7.61808 11.4029 7.38132 11.0913 7.00731C10.7796 6.6333 10.6271 6.15191 10.6667 5.66667C10.6667 5.48986 10.5965 5.32029 10.4714 5.19526C10.3464 5.07024 10.1768 5 10 5C9.82322 5 9.65365 5.07024 9.52863 5.19526C9.40361 5.32029 9.33337 5.48986 9.33337 5.66667C9.37293 6.15191 9.22048 6.6333 8.90881 7.00731C8.59713 7.38132 8.15112 7.61808 7.6667 7.66667C7.18228 7.61808 6.73627 7.38132 6.4246 7.00731C6.11292 6.6333 5.96047 6.15191 6.00003 5.66667C6.00003 5.48986 5.9298 5.32029 5.80477 5.19526C5.67975 5.07024 5.51018 5 5.33337 5C5.15656 5 4.98699 5.07024 4.86196 5.19526C4.73694 5.32029 4.6667 5.48986 4.6667 5.66667C4.70626 6.15191 4.55382 6.6333 4.24214 7.00731C3.93046 7.38132 3.48446 7.61808 3.00003 7.66667C2.7627 7.66461 2.52939 7.60514 2.32003 7.49333L2.31643 7.49253C2.02194 7.30996 1.7779 7.05648 1.60663 6.75526C1.43537 6.45405 1.34233 6.11471 1.33603 5.76827L2.48004 2.33333ZM7.0267 18.3333C6.42047 17.6528 6.06604 16.7849 6.02259 15.8745C5.97914 14.9642 6.24929 14.0664 6.78795 13.3312C7.3266 12.596 8.10115 12.0679 8.98228 11.8349C9.8634 11.602 10.7978 11.6783 11.6294 12.0513C12.461 12.4242 13.1395 13.0711 13.5517 13.884C13.9638 14.6969 14.0846 15.6266 13.8939 16.5178C13.7033 17.409 13.2126 18.2079 12.5039 18.7809C11.7953 19.354 10.9114 19.6667 10 19.6667C9.4384 19.6668 8.88309 19.5481 8.37062 19.3183C7.85815 19.0885 7.40014 18.7528 7.0267 18.3333ZM17.3334 17.6667C17.3342 17.7545 17.3176 17.8415 17.2844 17.9228C17.2512 18.0041 17.2021 18.0779 17.1401 18.14C17.078 18.2021 17.0041 18.2512 16.9229 18.2844C16.8416 18.3176 16.7545 18.3342 16.6667 18.3333H14.6134C15.0836 17.5227 15.3319 16.6025 15.3334 15.6654C15.3348 14.7283 15.0893 13.8073 14.6216 12.9953C14.1538 12.1832 13.4804 11.5088 12.6691 11.0398C11.8577 10.5708 10.9372 10.3239 10 10.3239C9.06291 10.3239 8.14233 10.5708 7.331 11.0398C6.51967 11.5088 5.84623 12.1832 5.3785 12.9953C4.91078 13.8073 4.66527 14.7283 4.66671 15.6654C4.66815 16.6025 4.91648 17.5227 5.3867 18.3333H3.33337C3.24558 18.3342 3.15849 18.3176 3.07722 18.2844C2.99594 18.2512 2.9221 18.2021 2.86002 18.14C2.79794 18.0779 2.74886 18.0041 2.71567 17.9228C2.68248 17.8415 2.66583 17.7545 2.6667 17.6667V8.98667C2.72577 8.99267 2.7827 8.97787 2.84163 8.98013C2.89497 8.9832 2.94643 9 3.00003 9C3.09516 8.99306 3.18983 8.98095 3.28363 8.96373C3.35937 8.9544 3.4343 8.9504 3.50883 8.93493C3.71402 8.89501 3.91391 8.83157 4.10457 8.74587C4.12897 8.73507 4.15443 8.72813 4.1787 8.71653C4.3849 8.61782 4.5788 8.49525 4.75643 8.35133C4.77483 8.33667 4.79563 8.326 4.8139 8.31133C4.99995 8.15446 5.16743 7.97681 5.3131 7.78187C5.3191 7.77387 5.3275 7.76853 5.33337 7.7604C5.59115 8.14223 5.9387 8.45496 6.34552 8.67115C6.75234 8.88735 7.206 9.00041 7.6667 9.00041C8.1274 9.00041 8.58106 8.88735 8.98788 8.67115C9.3947 8.45496 9.74225 8.14223 10 7.7604C10.2578 8.14223 10.6054 8.45496 11.0122 8.67115C11.419 8.88735 11.8727 9.00041 12.3334 9.00041C12.7941 9.00041 13.2477 8.88735 13.6545 8.67115C14.0614 8.45496 14.4089 8.14223 14.6667 7.7604C14.6754 7.77253 14.6879 7.7808 14.6967 7.79267C14.8346 7.97721 14.992 8.14633 15.1662 8.29707C15.2262 8.3484 15.2939 8.38547 15.3572 8.4316C15.4902 8.53326 15.6317 8.62328 15.7802 8.70067C15.8559 8.73827 15.9352 8.7624 16.0138 8.7932C16.2554 8.89736 16.5136 8.95781 16.7763 8.97173C16.8518 8.97813 16.923 9.0004 17 9.0004C17.05 9.0004 17.0979 8.98467 17.1476 8.98187C17.21 8.97907 17.2706 8.99427 17.3334 8.98707V17.6667Z"
                                  fill="currentColor"/>
                            <path d="M11.528 13.8619L9.33263 16.0573L8.47063 15.1953C8.34489 15.0738 8.17649 15.0066 8.00169 15.0082C7.8269 15.0097 7.65969 15.0798 7.53608 15.2034C7.41248 15.327 7.34236 15.4942 7.34085 15.669C7.33933 15.8438 7.40652 16.0122 7.52796 16.1379L8.86129 17.4713C8.98631 17.5963 9.15585 17.6665 9.33263 17.6665C9.5094 17.6665 9.67894 17.5963 9.80396 17.4713L12.4706 14.8046C12.5921 14.6789 12.6593 14.5105 12.6577 14.3357C12.6562 14.1609 12.5861 13.9937 12.4625 13.8701C12.3389 13.7465 12.1717 13.6763 11.9969 13.6748C11.8221 13.6733 11.6537 13.7405 11.528 13.8619Z"
                                  fill="currentColor"/>
                        </g>
                        <defs>
                            <clipPath id="clip0_338_318">
                                <rect width="20" height="21" fill="white"/>
                            </clipPath>
                        </defs>
                    </svg>
                    <span class="rtcl-tooltip"><?php _e( 'Store owner', 'classified-listing-store' ); ?></span>
                </span>
				<?php
			}
		}
	}

	public static function add_membership_badge( $listing ) {
		if ( is_a( $listing, Listing::class ) && $listing->can_show_membership_badge() ) {
			$member = rtclStore()->factory->get_membership( $listing->get_owner_id() );
			if ( $member && ! $member->is_expired() ) {
				?>
                <span class="rtcl-tooltip-wrapper">
                    <svg width="20" height="21" viewBox="0 0 20 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <g clip-path="url(#clip0_338_311)">
                            <mask id="path-1-outside-1_338_311" maskUnits="userSpaceOnUse" x="1" y="-1" width="19" height="23" fill="black">
                                <rect fill="white" x="1" y="-1" width="19" height="23"/>
                                <path d="M18.9207 18.8591C18.8277 18.9779 18.6733 19.0256 18.5321 18.9793L16.1512 18.1979L15.6182 20.7096C15.5866 20.8585 15.4692 20.9721 15.3228 20.9956C15.3043 20.9985 15.2858 21 15.2675 21C15.1407 21 15.0216 20.9307 14.9568 20.8154L12.7157 16.8216C12.6166 16.6451 12.6754 16.4193 12.8471 16.3174C13.0187 16.2155 13.2382 16.276 13.3372 16.4525L15.1148 19.6201L15.5341 17.6442C15.5557 17.5427 15.6178 17.4553 15.7053 17.4032C15.7927 17.3512 15.8975 17.3396 15.9937 17.3713L17.8667 17.9859L15.9401 14.5533C15.841 14.3767 15.8998 14.151 16.0714 14.049C16.243 13.9471 16.4625 14.0076 16.5616 14.1841L18.9519 18.443C19.026 18.575 19.0136 18.7404 18.9207 18.8591ZM8.1518 16.3174C7.98016 16.2155 7.76072 16.276 7.66164 16.4525L5.88408 19.6202L5.46477 17.6443C5.4432 17.5427 5.38104 17.4553 5.29357 17.4033C5.2061 17.3513 5.1014 17.3398 5.00511 17.3713L3.13342 17.9858L5.05993 14.5533C5.15901 14.3767 5.10024 14.151 4.92864 14.049C4.75704 13.9471 4.53756 14.0075 4.43848 14.1841L2.04808 18.443C1.97397 18.575 1.9864 18.7404 2.07938 18.8592C2.17236 18.9779 2.32673 19.0257 2.46795 18.9793L4.84771 18.198L5.38069 20.7096C5.4123 20.8585 5.52968 20.9721 5.67612 20.9957C5.69462 20.9986 5.71304 21 5.73138 21C5.85813 21 5.9773 20.9308 6.04205 20.8154L8.28317 16.8217C8.38225 16.6451 8.3234 16.4193 8.1518 16.3174ZM12.9956 15.8467C12.6018 15.7085 12.2034 15.8181 11.9307 16.1401L11.7861 16.3109C11.4506 16.7045 11.006 16.912 10.4995 16.912C9.99227 16.912 9.54784 16.7043 9.21429 16.3113L9.06929 16.14C8.79598 15.8183 8.39748 15.7086 8.00372 15.8469L7.79596 15.9201C7.31362 16.0888 6.82732 16.0399 6.38887 15.7787C5.95039 15.5188 5.66627 15.1101 5.56795 14.597L5.52589 14.3737C5.44615 13.9547 5.1545 13.6551 4.74588 13.573L4.52954 13.5285C4.03412 13.4297 3.63614 13.1376 3.38081 12.6842C3.12664 12.2303 3.07972 11.7302 3.24466 11.2373L3.31567 11.0239C3.44823 10.625 3.33891 10.2048 3.03028 9.92743L2.86462 9.77904C2.48243 9.43705 2.28033 8.9793 2.28033 8.4554C2.28033 7.93228 2.48243 7.47495 2.86478 7.1328L3.03072 6.98411C3.33891 6.70713 3.44827 6.28696 3.31563 5.88787L3.2445 5.6741C3.07976 5.18174 3.12668 4.68167 3.38041 4.22856C3.63618 3.77431 4.03412 3.48219 4.53174 3.38301L4.7444 3.33933C5.1545 3.25681 5.44615 2.95718 5.52605 2.53743L5.56771 2.3161C5.66627 1.80184 5.95043 1.39307 6.38963 1.13283C6.82728 0.872004 7.31358 0.823031 7.79524 0.991607L8.00384 1.06511C8.39744 1.20354 8.79586 1.09378 9.06964 0.771473L9.21393 0.601051C9.54641 0.20787 9.99096 0 10.4994 0C11.0072 0 11.4519 0.207665 11.7857 0.600682C11.7858 0.600805 11.7859 0.600969 11.786 0.601133L11.9307 0.772007C12.2034 1.09398 12.6018 1.2035 12.9965 1.06507L13.2023 0.992141C13.6852 0.823072 14.1715 0.872127 14.61 1.13336C15.0484 1.39316 15.3325 1.80192 15.4308 2.31499L15.4737 2.53644C15.5538 2.95723 15.8451 3.25689 16.2531 3.33913L16.4699 3.38347C16.9668 3.48277 17.3645 3.77517 17.6184 4.22865C17.8717 4.68097 17.9191 5.18071 17.7556 5.67381L17.6842 5.88812C17.5488 6.29332 17.6553 6.70286 17.9692 6.98424L18.1351 7.13386C18.5171 7.47569 18.7196 7.93302 18.7196 8.45549C18.7196 8.97869 18.5171 9.43643 18.134 9.7792L17.97 9.92706C17.6553 10.2092 17.5487 10.6188 17.684 11.0234L17.7554 11.2379C17.9191 11.7314 17.8717 12.2311 17.6183 12.6834C17.3644 13.137 16.9667 13.4293 16.4683 13.5289L16.2541 13.5728C15.845 13.6552 15.5537 13.9548 15.4738 14.3746L15.4306 14.5977C15.3324 15.1101 15.0483 15.5188 14.6091 15.7792C14.1714 16.0399 13.6851 16.089 13.2035 15.9204L12.9956 15.8467ZM13.2282 15.1483L13.436 15.2219C13.7184 15.3207 13.9928 15.2933 14.2503 15.1399C14.5089 14.9867 14.669 14.7561 14.7268 14.4543L14.7699 14.2316C14.9056 13.5187 15.4212 12.9883 16.1152 12.8485L16.33 12.8045C16.6238 12.7457 16.8475 12.5811 16.9967 12.3149C17.1458 12.0486 17.1726 11.7666 17.0765 11.4766L17.0054 11.263C16.7753 10.5749 16.9639 9.84979 17.4979 9.37113L17.6621 9.22306C17.8881 9.02085 18.002 8.7629 18.002 8.4554C18.002 8.14864 17.888 7.8911 17.6632 7.68984L17.4971 7.54005C16.9639 7.06225 16.7753 6.33708 17.0055 5.64842L17.0766 5.43501C17.1726 5.14544 17.1457 4.86341 16.9966 4.59709C16.8475 4.33086 16.6237 4.16622 16.3315 4.10781L16.1142 4.06335C15.4212 3.92369 14.9056 3.39327 14.7696 2.67934L14.7269 2.4583C14.6689 2.15585 14.5089 1.92534 14.251 1.77256C13.9928 1.6187 13.7184 1.59114 13.4347 1.69052L13.2291 1.76333C12.558 1.99888 11.8535 1.80463 11.3895 1.25678L11.2452 1.08627C11.049 0.85531 10.7981 0.738209 10.4994 0.738209C10.2006 0.738209 9.95021 0.855146 9.75517 1.08574L9.61036 1.25678C9.1448 1.80475 8.44026 1.99876 7.77144 1.76361L7.56332 1.69028C7.28032 1.59118 7.00598 1.61866 6.74846 1.7721C6.48986 1.9253 6.32979 2.15581 6.27194 2.45769L6.23035 2.67856C6.09424 3.39343 5.5782 3.92381 4.88343 4.0636L4.67016 4.1074C4.3762 4.16601 4.15202 4.33086 4.00171 4.59783C3.85295 4.86353 3.82636 5.14523 3.92312 5.4344L3.99453 5.64887C4.2233 6.33725 4.03468 7.062 3.50234 7.54046L3.33584 7.68967C3.11153 7.89041 2.99786 8.14795 2.99786 8.45536C2.99786 8.76356 3.11153 9.02151 3.33564 9.22204L3.5019 9.37101C4.03468 9.84987 4.2233 10.5746 3.99457 11.2628L3.92332 11.4769C3.82636 11.7667 3.85295 12.0484 4.00215 12.3149C4.15202 12.581 4.37624 12.7459 4.66813 12.8041L4.88502 12.8487C5.5782 12.9881 6.09428 13.5185 6.23019 14.2326L6.27218 14.4555C6.32979 14.7561 6.48986 14.9866 6.74774 15.1394C7.00594 15.2933 7.28028 15.3207 7.564 15.2214L7.77128 15.1484C7.95927 15.0823 8.15009 15.0501 8.33759 15.0501C8.81735 15.0501 9.27549 15.2611 9.60996 15.6547L9.75505 15.8261C9.95073 16.0567 10.2012 16.1738 10.4993 16.1738C10.7973 16.1738 11.0484 16.0565 11.2456 15.8252L11.3894 15.6552C11.8536 15.1074 12.5581 14.9132 13.2282 15.1483ZM10.4995 14.0473C7.50292 14.0473 5.06504 11.5388 5.06504 8.45545C5.06504 5.37275 7.50292 2.86478 10.4995 2.86478C13.4966 2.86478 15.935 5.37275 15.935 8.45545C15.935 11.5388 13.4966 14.0473 10.4995 14.0473ZM13.1701 12.4542L11.7081 11.4146C11.4495 11.233 11.3002 10.9414 11.3002 10.6157V10.0855C11.3002 9.98609 11.3392 9.89089 11.4083 9.82145C11.7656 9.46235 11.9709 9.06409 12.0103 8.846C12.0279 8.74863 12.0828 8.66262 12.1627 8.60733C12.1804 8.59506 12.1979 8.58321 12.2152 8.57152C12.2602 8.54105 12.3279 8.49523 12.3423 8.47444C12.342 8.47407 12.3433 8.46701 12.3433 8.45315V7.80669C12.3433 7.79545 12.3425 7.78832 12.3419 7.78442C12.3243 7.76424 12.2664 7.72425 12.2234 7.69464L12.215 7.68877C12.1128 7.61818 12.0529 7.49862 12.0563 7.372L12.0812 6.45582C12.0913 6.09295 11.9979 5.81261 11.7956 5.59855C11.522 5.30889 11.0516 5.14942 10.4712 5.14942C9.89084 5.14942 9.4205 5.30905 9.14671 5.59887C8.94445 5.81298 8.851 6.09324 8.86105 6.45562L8.88704 7.37155C8.89063 7.49833 8.83074 7.61814 8.7284 7.68877L8.71999 7.69464C8.67705 7.72429 8.61912 7.76424 8.60149 7.78442C8.60089 7.78832 8.60014 7.79545 8.60014 7.80669V8.45315C8.60014 8.47058 8.60217 8.47743 8.60217 8.47751C8.61397 8.4947 8.68347 8.54154 8.72943 8.57251C8.74602 8.58366 8.76285 8.59502 8.77983 8.60671C8.86053 8.66225 8.91591 8.74904 8.93333 8.84727C8.97168 9.06355 9.17614 9.46079 9.53441 9.82182C9.60334 9.89126 9.64214 9.98633 9.64214 10.0856V10.6157C9.64214 10.9407 9.49358 11.232 9.23451 11.4152L7.80142 12.4343C8.56645 12.9852 9.49681 13.309 10.4994 13.309C11.4901 13.309 12.4102 12.993 13.1701 12.4542ZM15.2173 8.45545C15.2173 5.77988 13.1009 3.60307 10.4995 3.60307C7.89863 3.60307 5.78269 5.77984 5.78269 8.45545C5.78269 9.82457 6.33665 11.0629 7.22582 11.9461L8.82732 10.8073C8.89298 10.7608 8.92456 10.6984 8.92456 10.6157V10.2358C8.60847 9.88843 8.36945 9.49053 8.26615 9.14202C8.09259 9.01934 7.88252 8.83132 7.88252 8.45311V7.80665C7.88252 7.49944 8.02139 7.31942 8.1642 7.19781L8.14375 6.47687C8.12828 5.92028 8.29717 5.43879 8.63211 5.08428C9.04221 4.65017 9.69532 4.41109 10.4712 4.41109C11.2473 4.41109 11.9004 4.65005 12.3103 5.08396C12.6453 5.4385 12.8141 5.92007 12.7986 6.47662L12.7791 7.1976C12.922 7.31921 13.061 7.49924 13.061 7.80665V8.45311C13.061 8.82935 12.8444 9.02278 12.6771 9.14173C12.5731 9.49143 12.3336 9.88966 12.0179 10.2361V10.6157C12.0179 10.6993 12.0486 10.7598 12.1145 10.8061L13.7506 11.9695C14.6537 11.0848 15.2173 9.83658 15.2173 8.45545Z"/>
                            </mask>
                            <path d="M18.9207 18.8591C18.8277 18.9779 18.6733 19.0256 18.5321 18.9793L16.1512 18.1979L15.6182 20.7096C15.5866 20.8585 15.4692 20.9721 15.3228 20.9956C15.3043 20.9985 15.2858 21 15.2675 21C15.1407 21 15.0216 20.9307 14.9568 20.8154L12.7157 16.8216C12.6166 16.6451 12.6754 16.4193 12.8471 16.3174C13.0187 16.2155 13.2382 16.276 13.3372 16.4525L15.1148 19.6201L15.5341 17.6442C15.5557 17.5427 15.6178 17.4553 15.7053 17.4032C15.7927 17.3512 15.8975 17.3396 15.9937 17.3713L17.8667 17.9859L15.9401 14.5533C15.841 14.3767 15.8998 14.151 16.0714 14.049C16.243 13.9471 16.4625 14.0076 16.5616 14.1841L18.9519 18.443C19.026 18.575 19.0136 18.7404 18.9207 18.8591ZM8.1518 16.3174C7.98016 16.2155 7.76072 16.276 7.66164 16.4525L5.88408 19.6202L5.46477 17.6443C5.4432 17.5427 5.38104 17.4553 5.29357 17.4033C5.2061 17.3513 5.1014 17.3398 5.00511 17.3713L3.13342 17.9858L5.05993 14.5533C5.15901 14.3767 5.10024 14.151 4.92864 14.049C4.75704 13.9471 4.53756 14.0075 4.43848 14.1841L2.04808 18.443C1.97397 18.575 1.9864 18.7404 2.07938 18.8592C2.17236 18.9779 2.32673 19.0257 2.46795 18.9793L4.84771 18.198L5.38069 20.7096C5.4123 20.8585 5.52968 20.9721 5.67612 20.9957C5.69462 20.9986 5.71304 21 5.73138 21C5.85813 21 5.9773 20.9308 6.04205 20.8154L8.28317 16.8217C8.38225 16.6451 8.3234 16.4193 8.1518 16.3174ZM12.9956 15.8467C12.6018 15.7085 12.2034 15.8181 11.9307 16.1401L11.7861 16.3109C11.4506 16.7045 11.006 16.912 10.4995 16.912C9.99227 16.912 9.54784 16.7043 9.21429 16.3113L9.06929 16.14C8.79598 15.8183 8.39748 15.7086 8.00372 15.8469L7.79596 15.9201C7.31362 16.0888 6.82732 16.0399 6.38887 15.7787C5.95039 15.5188 5.66627 15.1101 5.56795 14.597L5.52589 14.3737C5.44615 13.9547 5.1545 13.6551 4.74588 13.573L4.52954 13.5285C4.03412 13.4297 3.63614 13.1376 3.38081 12.6842C3.12664 12.2303 3.07972 11.7302 3.24466 11.2373L3.31567 11.0239C3.44823 10.625 3.33891 10.2048 3.03028 9.92743L2.86462 9.77904C2.48243 9.43705 2.28033 8.9793 2.28033 8.4554C2.28033 7.93228 2.48243 7.47495 2.86478 7.1328L3.03072 6.98411C3.33891 6.70713 3.44827 6.28696 3.31563 5.88787L3.2445 5.6741C3.07976 5.18174 3.12668 4.68167 3.38041 4.22856C3.63618 3.77431 4.03412 3.48219 4.53174 3.38301L4.7444 3.33933C5.1545 3.25681 5.44615 2.95718 5.52605 2.53743L5.56771 2.3161C5.66627 1.80184 5.95043 1.39307 6.38963 1.13283C6.82728 0.872004 7.31358 0.823031 7.79524 0.991607L8.00384 1.06511C8.39744 1.20354 8.79586 1.09378 9.06964 0.771473L9.21393 0.601051C9.54641 0.20787 9.99096 0 10.4994 0C11.0072 0 11.4519 0.207665 11.7857 0.600682C11.7858 0.600805 11.7859 0.600969 11.786 0.601133L11.9307 0.772007C12.2034 1.09398 12.6018 1.2035 12.9965 1.06507L13.2023 0.992141C13.6852 0.823072 14.1715 0.872127 14.61 1.13336C15.0484 1.39316 15.3325 1.80192 15.4308 2.31499L15.4737 2.53644C15.5538 2.95723 15.8451 3.25689 16.2531 3.33913L16.4699 3.38347C16.9668 3.48277 17.3645 3.77517 17.6184 4.22865C17.8717 4.68097 17.9191 5.18071 17.7556 5.67381L17.6842 5.88812C17.5488 6.29332 17.6553 6.70286 17.9692 6.98424L18.1351 7.13386C18.5171 7.47569 18.7196 7.93302 18.7196 8.45549C18.7196 8.97869 18.5171 9.43643 18.134 9.7792L17.97 9.92706C17.6553 10.2092 17.5487 10.6188 17.684 11.0234L17.7554 11.2379C17.9191 11.7314 17.8717 12.2311 17.6183 12.6834C17.3644 13.137 16.9667 13.4293 16.4683 13.5289L16.2541 13.5728C15.845 13.6552 15.5537 13.9548 15.4738 14.3746L15.4306 14.5977C15.3324 15.1101 15.0483 15.5188 14.6091 15.7792C14.1714 16.0399 13.6851 16.089 13.2035 15.9204L12.9956 15.8467ZM13.2282 15.1483L13.436 15.2219C13.7184 15.3207 13.9928 15.2933 14.2503 15.1399C14.5089 14.9867 14.669 14.7561 14.7268 14.4543L14.7699 14.2316C14.9056 13.5187 15.4212 12.9883 16.1152 12.8485L16.33 12.8045C16.6238 12.7457 16.8475 12.5811 16.9967 12.3149C17.1458 12.0486 17.1726 11.7666 17.0765 11.4766L17.0054 11.263C16.7753 10.5749 16.9639 9.84979 17.4979 9.37113L17.6621 9.22306C17.8881 9.02085 18.002 8.7629 18.002 8.4554C18.002 8.14864 17.888 7.8911 17.6632 7.68984L17.4971 7.54005C16.9639 7.06225 16.7753 6.33708 17.0055 5.64842L17.0766 5.43501C17.1726 5.14544 17.1457 4.86341 16.9966 4.59709C16.8475 4.33086 16.6237 4.16622 16.3315 4.10781L16.1142 4.06335C15.4212 3.92369 14.9056 3.39327 14.7696 2.67934L14.7269 2.4583C14.6689 2.15585 14.5089 1.92534 14.251 1.77256C13.9928 1.6187 13.7184 1.59114 13.4347 1.69052L13.2291 1.76333C12.558 1.99888 11.8535 1.80463 11.3895 1.25678L11.2452 1.08627C11.049 0.85531 10.7981 0.738209 10.4994 0.738209C10.2006 0.738209 9.95021 0.855146 9.75517 1.08574L9.61036 1.25678C9.1448 1.80475 8.44026 1.99876 7.77144 1.76361L7.56332 1.69028C7.28032 1.59118 7.00598 1.61866 6.74846 1.7721C6.48986 1.9253 6.32979 2.15581 6.27194 2.45769L6.23035 2.67856C6.09424 3.39343 5.5782 3.92381 4.88343 4.0636L4.67016 4.1074C4.3762 4.16601 4.15202 4.33086 4.00171 4.59783C3.85295 4.86353 3.82636 5.14523 3.92312 5.4344L3.99453 5.64887C4.2233 6.33725 4.03468 7.062 3.50234 7.54046L3.33584 7.68967C3.11153 7.89041 2.99786 8.14795 2.99786 8.45536C2.99786 8.76356 3.11153 9.02151 3.33564 9.22204L3.5019 9.37101C4.03468 9.84987 4.2233 10.5746 3.99457 11.2628L3.92332 11.4769C3.82636 11.7667 3.85295 12.0484 4.00215 12.3149C4.15202 12.581 4.37624 12.7459 4.66813 12.8041L4.88502 12.8487C5.5782 12.9881 6.09428 13.5185 6.23019 14.2326L6.27218 14.4555C6.32979 14.7561 6.48986 14.9866 6.74774 15.1394C7.00594 15.2933 7.28028 15.3207 7.564 15.2214L7.77128 15.1484C7.95927 15.0823 8.15009 15.0501 8.33759 15.0501C8.81735 15.0501 9.27549 15.2611 9.60996 15.6547L9.75505 15.8261C9.95073 16.0567 10.2012 16.1738 10.4993 16.1738C10.7973 16.1738 11.0484 16.0565 11.2456 15.8252L11.3894 15.6552C11.8536 15.1074 12.5581 14.9132 13.2282 15.1483ZM10.4995 14.0473C7.50292 14.0473 5.06504 11.5388 5.06504 8.45545C5.06504 5.37275 7.50292 2.86478 10.4995 2.86478C13.4966 2.86478 15.935 5.37275 15.935 8.45545C15.935 11.5388 13.4966 14.0473 10.4995 14.0473ZM13.1701 12.4542L11.7081 11.4146C11.4495 11.233 11.3002 10.9414 11.3002 10.6157V10.0855C11.3002 9.98609 11.3392 9.89089 11.4083 9.82145C11.7656 9.46235 11.9709 9.06409 12.0103 8.846C12.0279 8.74863 12.0828 8.66262 12.1627 8.60733C12.1804 8.59506 12.1979 8.58321 12.2152 8.57152C12.2602 8.54105 12.3279 8.49523 12.3423 8.47444C12.342 8.47407 12.3433 8.46701 12.3433 8.45315V7.80669C12.3433 7.79545 12.3425 7.78832 12.3419 7.78442C12.3243 7.76424 12.2664 7.72425 12.2234 7.69464L12.215 7.68877C12.1128 7.61818 12.0529 7.49862 12.0563 7.372L12.0812 6.45582C12.0913 6.09295 11.9979 5.81261 11.7956 5.59855C11.522 5.30889 11.0516 5.14942 10.4712 5.14942C9.89084 5.14942 9.4205 5.30905 9.14671 5.59887C8.94445 5.81298 8.851 6.09324 8.86105 6.45562L8.88704 7.37155C8.89063 7.49833 8.83074 7.61814 8.7284 7.68877L8.71999 7.69464C8.67705 7.72429 8.61912 7.76424 8.60149 7.78442C8.60089 7.78832 8.60014 7.79545 8.60014 7.80669V8.45315C8.60014 8.47058 8.60217 8.47743 8.60217 8.47751C8.61397 8.4947 8.68347 8.54154 8.72943 8.57251C8.74602 8.58366 8.76285 8.59502 8.77983 8.60671C8.86053 8.66225 8.91591 8.74904 8.93333 8.84727C8.97168 9.06355 9.17614 9.46079 9.53441 9.82182C9.60334 9.89126 9.64214 9.98633 9.64214 10.0856V10.6157C9.64214 10.9407 9.49358 11.232 9.23451 11.4152L7.80142 12.4343C8.56645 12.9852 9.49681 13.309 10.4994 13.309C11.4901 13.309 12.4102 12.993 13.1701 12.4542ZM15.2173 8.45545C15.2173 5.77988 13.1009 3.60307 10.4995 3.60307C7.89863 3.60307 5.78269 5.77984 5.78269 8.45545C5.78269 9.82457 6.33665 11.0629 7.22582 11.9461L8.82732 10.8073C8.89298 10.7608 8.92456 10.6984 8.92456 10.6157V10.2358C8.60847 9.88843 8.36945 9.49053 8.26615 9.14202C8.09259 9.01934 7.88252 8.83132 7.88252 8.45311V7.80665C7.88252 7.49944 8.02139 7.31942 8.1642 7.19781L8.14375 6.47687C8.12828 5.92028 8.29717 5.43879 8.63211 5.08428C9.04221 4.65017 9.69532 4.41109 10.4712 4.41109C11.2473 4.41109 11.9004 4.65005 12.3103 5.08396C12.6453 5.4385 12.8141 5.92007 12.7986 6.47662L12.7791 7.1976C12.922 7.31921 13.061 7.49924 13.061 7.80665V8.45311C13.061 8.82935 12.8444 9.02278 12.6771 9.14173C12.5731 9.49143 12.3336 9.88966 12.0179 10.2361V10.6157C12.0179 10.6993 12.0486 10.7598 12.1145 10.8061L13.7506 11.9695C14.6537 11.0848 15.2173 9.83658 15.2173 8.45545Z"
                                  fill="currentColor"/>
                            <path d="M18.9207 18.8591C18.8277 18.9779 18.6733 19.0256 18.5321 18.9793L16.1512 18.1979L15.6182 20.7096C15.5866 20.8585 15.4692 20.9721 15.3228 20.9956C15.3043 20.9985 15.2858 21 15.2675 21C15.1407 21 15.0216 20.9307 14.9568 20.8154L12.7157 16.8216C12.6166 16.6451 12.6754 16.4193 12.8471 16.3174C13.0187 16.2155 13.2382 16.276 13.3372 16.4525L15.1148 19.6201L15.5341 17.6442C15.5557 17.5427 15.6178 17.4553 15.7053 17.4032C15.7927 17.3512 15.8975 17.3396 15.9937 17.3713L17.8667 17.9859L15.9401 14.5533C15.841 14.3767 15.8998 14.151 16.0714 14.049C16.243 13.9471 16.4625 14.0076 16.5616 14.1841L18.9519 18.443C19.026 18.575 19.0136 18.7404 18.9207 18.8591ZM8.1518 16.3174C7.98016 16.2155 7.76072 16.276 7.66164 16.4525L5.88408 19.6202L5.46477 17.6443C5.4432 17.5427 5.38104 17.4553 5.29357 17.4033C5.2061 17.3513 5.1014 17.3398 5.00511 17.3713L3.13342 17.9858L5.05993 14.5533C5.15901 14.3767 5.10024 14.151 4.92864 14.049C4.75704 13.9471 4.53756 14.0075 4.43848 14.1841L2.04808 18.443C1.97397 18.575 1.9864 18.7404 2.07938 18.8592C2.17236 18.9779 2.32673 19.0257 2.46795 18.9793L4.84771 18.198L5.38069 20.7096C5.4123 20.8585 5.52968 20.9721 5.67612 20.9957C5.69462 20.9986 5.71304 21 5.73138 21C5.85813 21 5.9773 20.9308 6.04205 20.8154L8.28317 16.8217C8.38225 16.6451 8.3234 16.4193 8.1518 16.3174ZM12.9956 15.8467C12.6018 15.7085 12.2034 15.8181 11.9307 16.1401L11.7861 16.3109C11.4506 16.7045 11.006 16.912 10.4995 16.912C9.99227 16.912 9.54784 16.7043 9.21429 16.3113L9.06929 16.14C8.79598 15.8183 8.39748 15.7086 8.00372 15.8469L7.79596 15.9201C7.31362 16.0888 6.82732 16.0399 6.38887 15.7787C5.95039 15.5188 5.66627 15.1101 5.56795 14.597L5.52589 14.3737C5.44615 13.9547 5.1545 13.6551 4.74588 13.573L4.52954 13.5285C4.03412 13.4297 3.63614 13.1376 3.38081 12.6842C3.12664 12.2303 3.07972 11.7302 3.24466 11.2373L3.31567 11.0239C3.44823 10.625 3.33891 10.2048 3.03028 9.92743L2.86462 9.77904C2.48243 9.43705 2.28033 8.9793 2.28033 8.4554C2.28033 7.93228 2.48243 7.47495 2.86478 7.1328L3.03072 6.98411C3.33891 6.70713 3.44827 6.28696 3.31563 5.88787L3.2445 5.6741C3.07976 5.18174 3.12668 4.68167 3.38041 4.22856C3.63618 3.77431 4.03412 3.48219 4.53174 3.38301L4.7444 3.33933C5.1545 3.25681 5.44615 2.95718 5.52605 2.53743L5.56771 2.3161C5.66627 1.80184 5.95043 1.39307 6.38963 1.13283C6.82728 0.872004 7.31358 0.823031 7.79524 0.991607L8.00384 1.06511C8.39744 1.20354 8.79586 1.09378 9.06964 0.771473L9.21393 0.601051C9.54641 0.20787 9.99096 0 10.4994 0C11.0072 0 11.4519 0.207665 11.7857 0.600682C11.7858 0.600805 11.7859 0.600969 11.786 0.601133L11.9307 0.772007C12.2034 1.09398 12.6018 1.2035 12.9965 1.06507L13.2023 0.992141C13.6852 0.823072 14.1715 0.872127 14.61 1.13336C15.0484 1.39316 15.3325 1.80192 15.4308 2.31499L15.4737 2.53644C15.5538 2.95723 15.8451 3.25689 16.2531 3.33913L16.4699 3.38347C16.9668 3.48277 17.3645 3.77517 17.6184 4.22865C17.8717 4.68097 17.9191 5.18071 17.7556 5.67381L17.6842 5.88812C17.5488 6.29332 17.6553 6.70286 17.9692 6.98424L18.1351 7.13386C18.5171 7.47569 18.7196 7.93302 18.7196 8.45549C18.7196 8.97869 18.5171 9.43643 18.134 9.7792L17.97 9.92706C17.6553 10.2092 17.5487 10.6188 17.684 11.0234L17.7554 11.2379C17.9191 11.7314 17.8717 12.2311 17.6183 12.6834C17.3644 13.137 16.9667 13.4293 16.4683 13.5289L16.2541 13.5728C15.845 13.6552 15.5537 13.9548 15.4738 14.3746L15.4306 14.5977C15.3324 15.1101 15.0483 15.5188 14.6091 15.7792C14.1714 16.0399 13.6851 16.089 13.2035 15.9204L12.9956 15.8467ZM13.2282 15.1483L13.436 15.2219C13.7184 15.3207 13.9928 15.2933 14.2503 15.1399C14.5089 14.9867 14.669 14.7561 14.7268 14.4543L14.7699 14.2316C14.9056 13.5187 15.4212 12.9883 16.1152 12.8485L16.33 12.8045C16.6238 12.7457 16.8475 12.5811 16.9967 12.3149C17.1458 12.0486 17.1726 11.7666 17.0765 11.4766L17.0054 11.263C16.7753 10.5749 16.9639 9.84979 17.4979 9.37113L17.6621 9.22306C17.8881 9.02085 18.002 8.7629 18.002 8.4554C18.002 8.14864 17.888 7.8911 17.6632 7.68984L17.4971 7.54005C16.9639 7.06225 16.7753 6.33708 17.0055 5.64842L17.0766 5.43501C17.1726 5.14544 17.1457 4.86341 16.9966 4.59709C16.8475 4.33086 16.6237 4.16622 16.3315 4.10781L16.1142 4.06335C15.4212 3.92369 14.9056 3.39327 14.7696 2.67934L14.7269 2.4583C14.6689 2.15585 14.5089 1.92534 14.251 1.77256C13.9928 1.6187 13.7184 1.59114 13.4347 1.69052L13.2291 1.76333C12.558 1.99888 11.8535 1.80463 11.3895 1.25678L11.2452 1.08627C11.049 0.85531 10.7981 0.738209 10.4994 0.738209C10.2006 0.738209 9.95021 0.855146 9.75517 1.08574L9.61036 1.25678C9.1448 1.80475 8.44026 1.99876 7.77144 1.76361L7.56332 1.69028C7.28032 1.59118 7.00598 1.61866 6.74846 1.7721C6.48986 1.9253 6.32979 2.15581 6.27194 2.45769L6.23035 2.67856C6.09424 3.39343 5.5782 3.92381 4.88343 4.0636L4.67016 4.1074C4.3762 4.16601 4.15202 4.33086 4.00171 4.59783C3.85295 4.86353 3.82636 5.14523 3.92312 5.4344L3.99453 5.64887C4.2233 6.33725 4.03468 7.062 3.50234 7.54046L3.33584 7.68967C3.11153 7.89041 2.99786 8.14795 2.99786 8.45536C2.99786 8.76356 3.11153 9.02151 3.33564 9.22204L3.5019 9.37101C4.03468 9.84987 4.2233 10.5746 3.99457 11.2628L3.92332 11.4769C3.82636 11.7667 3.85295 12.0484 4.00215 12.3149C4.15202 12.581 4.37624 12.7459 4.66813 12.8041L4.88502 12.8487C5.5782 12.9881 6.09428 13.5185 6.23019 14.2326L6.27218 14.4555C6.32979 14.7561 6.48986 14.9866 6.74774 15.1394C7.00594 15.2933 7.28028 15.3207 7.564 15.2214L7.77128 15.1484C7.95927 15.0823 8.15009 15.0501 8.33759 15.0501C8.81735 15.0501 9.27549 15.2611 9.60996 15.6547L9.75505 15.8261C9.95073 16.0567 10.2012 16.1738 10.4993 16.1738C10.7973 16.1738 11.0484 16.0565 11.2456 15.8252L11.3894 15.6552C11.8536 15.1074 12.5581 14.9132 13.2282 15.1483ZM10.4995 14.0473C7.50292 14.0473 5.06504 11.5388 5.06504 8.45545C5.06504 5.37275 7.50292 2.86478 10.4995 2.86478C13.4966 2.86478 15.935 5.37275 15.935 8.45545C15.935 11.5388 13.4966 14.0473 10.4995 14.0473ZM13.1701 12.4542L11.7081 11.4146C11.4495 11.233 11.3002 10.9414 11.3002 10.6157V10.0855C11.3002 9.98609 11.3392 9.89089 11.4083 9.82145C11.7656 9.46235 11.9709 9.06409 12.0103 8.846C12.0279 8.74863 12.0828 8.66262 12.1627 8.60733C12.1804 8.59506 12.1979 8.58321 12.2152 8.57152C12.2602 8.54105 12.3279 8.49523 12.3423 8.47444C12.342 8.47407 12.3433 8.46701 12.3433 8.45315V7.80669C12.3433 7.79545 12.3425 7.78832 12.3419 7.78442C12.3243 7.76424 12.2664 7.72425 12.2234 7.69464L12.215 7.68877C12.1128 7.61818 12.0529 7.49862 12.0563 7.372L12.0812 6.45582C12.0913 6.09295 11.9979 5.81261 11.7956 5.59855C11.522 5.30889 11.0516 5.14942 10.4712 5.14942C9.89084 5.14942 9.4205 5.30905 9.14671 5.59887C8.94445 5.81298 8.851 6.09324 8.86105 6.45562L8.88704 7.37155C8.89063 7.49833 8.83074 7.61814 8.7284 7.68877L8.71999 7.69464C8.67705 7.72429 8.61912 7.76424 8.60149 7.78442C8.60089 7.78832 8.60014 7.79545 8.60014 7.80669V8.45315C8.60014 8.47058 8.60217 8.47743 8.60217 8.47751C8.61397 8.4947 8.68347 8.54154 8.72943 8.57251C8.74602 8.58366 8.76285 8.59502 8.77983 8.60671C8.86053 8.66225 8.91591 8.74904 8.93333 8.84727C8.97168 9.06355 9.17614 9.46079 9.53441 9.82182C9.60334 9.89126 9.64214 9.98633 9.64214 10.0856V10.6157C9.64214 10.9407 9.49358 11.232 9.23451 11.4152L7.80142 12.4343C8.56645 12.9852 9.49681 13.309 10.4994 13.309C11.4901 13.309 12.4102 12.993 13.1701 12.4542ZM15.2173 8.45545C15.2173 5.77988 13.1009 3.60307 10.4995 3.60307C7.89863 3.60307 5.78269 5.77984 5.78269 8.45545C5.78269 9.82457 6.33665 11.0629 7.22582 11.9461L8.82732 10.8073C8.89298 10.7608 8.92456 10.6984 8.92456 10.6157V10.2358C8.60847 9.88843 8.36945 9.49053 8.26615 9.14202C8.09259 9.01934 7.88252 8.83132 7.88252 8.45311V7.80665C7.88252 7.49944 8.02139 7.31942 8.1642 7.19781L8.14375 6.47687C8.12828 5.92028 8.29717 5.43879 8.63211 5.08428C9.04221 4.65017 9.69532 4.41109 10.4712 4.41109C11.2473 4.41109 11.9004 4.65005 12.3103 5.08396C12.6453 5.4385 12.8141 5.92007 12.7986 6.47662L12.7791 7.1976C12.922 7.31921 13.061 7.49924 13.061 7.80665V8.45311C13.061 8.82935 12.8444 9.02278 12.6771 9.14173C12.5731 9.49143 12.3336 9.88966 12.0179 10.2361V10.6157C12.0179 10.6993 12.0486 10.7598 12.1145 10.8061L13.7506 11.9695C14.6537 11.0848 15.2173 9.83658 15.2173 8.45545Z"
                                  stroke="currentColor" stroke-width="0.4" mask="url(#path-1-outside-1_338_311)"/>
                        </g>
                        <defs>
                            <clipPath id="clip0_338_311">
                                <rect width="20" height="21" fill="white"/>
                            </clipPath>
                        </defs>
                    </svg>
                    <span class="rtcl-tooltip"><?php _e( 'Member', 'classified-listing-store' ); ?></span>
                </span>
				<?php
			}
		}
	}

	public static function g_recaptcha_v2_placeholder() {
		$misc_settings = Functions::get_option( 'rtcl_misc_settings' );
		if ( ! empty( $misc_settings['recaptcha_site_key'] ) && ! empty( $misc_settings['recaptcha_forms'] )
		     && in_array( 'store_contact', $misc_settings['recaptcha_forms'] )
		     && ( ! empty( $misc_settings['recaptcha_version'] ) && $misc_settings['recaptcha_version'] !== 3 )
		)
			?>
            <div class="form-group">
                <div class="rtcl-g-recaptcha-wrap"></div>
            </div>
			<?php
	}

	public static function add_user_login_link() {
		$redirect_to = add_query_arg( 'redirect_to', get_the_permalink(), Link::get_my_account_page_link() );
		?>
        <div class='list-group-item'>
			<?php echo wp_kses( sprintf( __( "Please <a href='%s'>login</a> to view the store contact.", "classified-listing-store" ), esc_url( $redirect_to ) ),
				[ 'a' => [ 'href' => [] ] ] ); ?>
        </div>
		<?php
	}

	static function loop_item_content_start() {
		echo apply_filters( 'rtcl_store_loop_item_content_start', '<div class="item-content">' );
	}

	static function store_meta() {
		global $store;
		$store->the_metas();
	}

	static function loop_item_store_title() {
		global $store;
		if ( is_a( $store, Store::class ) ) {
			echo '<h3 class="rtcl-store-title">' . $store->get_the_title() . '</h3>';
		}
	}

	static function loop_item_content_end() {
		echo apply_filters( 'rtcl_store_loop_item_content_end', '</div>' );
	}

	static function open_store_link() {
		global $store;
		if ( is_a( $store, Store::class ) ) {
			echo sprintf( '<a href="%s" class="rtcl-store-link">', $store->get_the_permalink() );
		}
	}

	static function close_store_link() {
		echo '</a>';
	}

	static function store_thumbnail() {
		RtclFunctions::get_template( 'store/loop/thumbnail', '', '', rtclStore()->get_plugin_template_path() );
	}

	static function pagination() {
		StoreFunctions::pagination();
	}

	static function store_actions() {
		RtclFunctions::get_template( 'store/loop/actions', null, '', rtclStore()->get_plugin_template_path() );
	}

	/**
	 * Output the result count text (Showing x - x of x results).
	 */
	static function result_count() {
		if ( ! StoreFunctions::get_loop_prop( 'is_paginated' ) ) {
			return;
		}
		$args = [
			'total'    => StoreFunctions::get_loop_prop( 'total' ),
			'per_page' => StoreFunctions::get_loop_prop( 'per_page' ),
			'current'  => StoreFunctions::get_loop_prop( 'current_page' ),
		];

		RtclFunctions::get_template( 'listing/loop/result-count', $args );
	}


	static function no_stores_found() {
		RtclFunctions::get_template( 'store/loop/no-stores-found', null, '', rtclStore()->get_plugin_template_path() );
	}

	/**
	 * Output the Listing sorting options.
	 */
	static function catalog_ordering() {
		if ( ! StoreFunctions::get_loop_prop( 'is_paginated' ) ) {
			return;
		}
		$orderby                 = RtclFunctions::get_option_item( 'rtcl_general_settings', 'orderby' );
		$order                   = RtclFunctions::get_option_item( 'rtcl_general_settings', 'order' );
		$orderby_order           = $orderby . "-" . $order;
		$is_orderby_selected     = 'date-desc' === apply_filters( 'rtcl_store_default_catalog_orderby', $orderby_order );
		$catalog_orderby_options = StoreOptions::get_store_orderby_options();

		$default_orderby = StoreFunctions::get_loop_prop( 'is_search' ) ? 'relevance' : $orderby_order;
		$orderby         = isset( $_GET['orderby'] ) ? RtclFunctions::clean( wp_unslash( $_GET['orderby'] ) )
			: $default_orderby; // WPCS: sanitization ok, input var ok, CSRF ok.

		if ( StoreFunctions::get_loop_prop( 'is_search' ) ) {
			$catalog_orderby_options = array_merge( [ 'relevance' => esc_html__( 'Relevance', 'classified-listing-store' ) ], $catalog_orderby_options );

			unset( $catalog_orderby_options['menu_order'] );
		}

		if ( ! $is_orderby_selected ) {
			unset( $catalog_orderby_options['date-desc'] );
		}

		if ( ! array_key_exists( $orderby, $catalog_orderby_options ) ) {
			$orderby = current( array_keys( $catalog_orderby_options ) );
		}

		RtclFunctions::get_template(
			'listing/loop/orderby',
			[
				'catalog_orderby_options' => $catalog_orderby_options,
				'orderby'                 => $orderby,
				'is_orderby_selected'     => $is_orderby_selected,
			]
		);
	}

	static function single_store_expired_content() {
		?>
        <div class="rtcl store-content-wrap">
            <p><?php _e( 'This store is unavailable due to membership is expired for this store owner.', 'classified-listing-store' ) ?></p>
        </div>
		<?php
	}

	static function store_detail_modal() {
		RtclFunctions::get_template( 'store/details-modal', null, '', rtclStore()->get_plugin_template_path() );
	}

	static function store_social_email( $store = false ) {
		if ( ! $store ) {
			global $store;
		}

		if ( $store_email = $store->get_email() ): ?>
            <div class="store-info-item store-email">
                <div class="store-email-label">
                    <span class="icon"><span class="rtcl-icon-mail"></span></span>
                    <span class="text"><?php echo apply_filters( 'rtcl_store_single_store_email_button_text',
							esc_html__( "Message Store Owner", "classified-listing-store" ) ); ?></span>
                </div>
				<?php RtclFunctions::get_template( 'store/contact-form', null, '', rtclStore()->get_plugin_template_path() ); ?>
            </div>
		<?php endif;
	}

	static function store_social_media( $store = false ) {
		if ( ! $store ) {
			global $store;
		}

		if ( $store->get_social_media() ): ?>
            <div class="store-info-item store-social-media">
				<?php echo wp_kses_post( $store->get_social_media_html() ) ?>
            </div>
		<?php endif;
	}

	static function store_phone( $store = false ) {
		if ( ! $store ) {
			global $store;
		}

		$store_phone       = $store->get_phone();
		$whatsapp_number   = $store->get_whatsapp();

		if ( $store_phone || $whatsapp_number ):
			$safe_phone = substr_replace( $store_phone, 'XXX', - 3 );
			$phone_options = [];
			/*$phone_options = [
				'safe_phone'   => $safe_phone,
				'phone_hidden' => substr( $store_phone, - 3 )
			];*/

			if ( $store_phone ) {
				$phone_options = [
					'safe_phone'   => mb_substr( $store_phone, 0, mb_strlen( $store_phone ) - 3 ) . apply_filters( 'rtcl_phone_number_placeholder', 'XXX' ),
					'phone_hidden' => mb_substr( $store_phone, - 3 )
				];
			}

			if ( $whatsapp_number ) {
				$phone_options['safe_whatsapp_number'] = mb_substr( $whatsapp_number, 0, mb_strlen( $whatsapp_number ) - 3 )
				                                         . apply_filters( 'rtcl_phone_number_placeholder', 'XXX' );
				$phone_options['whatsapp_hidden']      = mb_substr( $whatsapp_number, - 3 );
			}

			$phone_options = apply_filters( 'rtcl_phone_number_options', $phone_options, [
				'phone'           => $store_phone,
				'whatsapp_number' => $whatsapp_number
			] )


			?>
            <div class="store-info-item store-phone reveal-phone"
                 data-options="<?php echo htmlspecialchars( wp_json_encode( $phone_options ) ); ?>">
                <div class="icon"><span class="rtcl-icon-mobile" aria-hidden="true"></span></div>
                <div class="text">
                    <div class='numbers'>
						<?php if ( $store_phone ) {
							echo esc_html( $phone_options['safe_phone'] );
						} elseif ( $whatsapp_number ) {
							echo esc_html( $phone_options['safe_whatsapp_number'] );
						} ?>
                    </div>
                    <small class='text-muted'><?php esc_html_e( "Click to reveal phone number",
							"classified-listing-store" ) ?></small>
                </div>
            </div>
		<?php endif;
	}

	static function store_website( $store = false ) {
		if ( ! $store ) {
			global $store;
		}

		if ( $website = $store->get_website() ): ?>
            <div class="store-info-item store-website">
                <div class="icon"><span class="rtcl-icon-link" aria-hidden="true"></span></div>
                <div class="text">
                    <a href="<?php echo esc_url( $website ); ?>" target="_blank">
						<?php _e( 'Visit Website', 'classified-listing-store' ); ?>
                    </a>
                </div>
            </div>
		<?php endif;
	}

	static function store_address( $store = false ) {
		if ( ! $store ) {
			global $store;
		}

		if ( $store_address = $store->get_address() ): ?>
            <div class="store-info-item store-address">
                <div class="icon"><span class="rtcl-icon-location" aria-hidden="true"></span></div>
                <div class="text"><?php echo esc_html( $store_address ); ?></div>
            </div>
		<?php endif;
	}

	static function store_hours( $store = false ) {
		if ( ! $store ) {
			global $store;
		}
		$store_oh_type   = get_post_meta( $store->get_id(), 'oh_type', true );
		$oh_hours        = get_post_meta( $store->get_id(), 'oh_hours', true );
		$oh_hours        = is_array( $oh_hours ) ? $oh_hours : ( $oh_hours ? (array) $oh_hours : [] );
		$today           = strtolower( date( 'w' ) );
		$oh_current_hour = [];
		$now_status      = '';
		$now_open        = false;
		if ( $store_oh_type == 'selected' && ! empty( $oh_hours ) && isset( $oh_hours[ $today ]['active'] ) ) {
			$oh_current_hour   = $oh_hours[ $today ];
			$now_status        = esc_html__( "Close now", "classified-listing-store" );
			$local             = get_date_from_gmt( date( "Y-m-d H:i:s" ) );
			$now               = \DateTime::createFromFormat( 'Y-m-d H:i:s', $local );
			$store_time_format = StoreFunctions::get_store_time_format();
			try {
				$date_open = new \DateTime( isset( $oh_hours[ $today ]['open'] ) ? $oh_hours[ $today ]['open'] : '9:00 AM' );
			} catch ( \Exception $e ) {
				$date_open = new \DateTime( '9:00 AM' );
			}
			try {
				$date_close = new \DateTime( isset( $oh_hours[ $today ]['close'] ) ? $oh_hours[ $today ]['close'] : '9:00 PM' );
			} catch ( \Exception $e ) {
				$date_open = new \DateTime( '9:00 PM' );
			}

			$oh_current_hour['open']  = $date_open->format( $store_time_format );
			$oh_current_hour['close'] = $date_close->format( $store_time_format );
			$date_close->add( new \DateInterval( 'PT1M' ) );
			if ( $now >= $date_open && $now <= $date_close ) {
				$now_status = esc_html__( "Open now", "classified-listing-store" );
				$now_open   = true;
			}

		}
		?>
        <div class="store-info-item store-hour">
            <div class="icon"><span class="rtcl-icon-clock"></span></div>
            <div class="text">
				<?php if ( $store_oh_type == 'selected' ): ?>
					<?php if ( ! empty( $oh_current_hour ) ): ?>
                        <span class="open-day">
                                    <?php $now_open_class = $now_open ? ' store-open' : ' store-close'; ?>
                                    <span class="store-now<?php echo esc_attr( $now_open_class ); ?>"><?php echo esc_html( $now_status ); ?></span>
                                    <span class="label"><?php esc_html_e( "Open Today:", "classified-listing-store" ) ?></span>
                                    <span class="hours">
                                        <span class="open-hour"><?php echo isset( $oh_current_hour['open'] ) ? esc_html( $oh_current_hour['open'] )
		                                        : ''; ?></span>
                                        <span class="close-hour"><?php echo isset( $oh_current_hour['close'] ) ? esc_html( $oh_current_hour['close'] )
		                                        : ''; ?></span>
                                    </span>
                                </span>
					<?php else: ?>
                        <span class="close-day"><?php esc_html_e( "Close Today", "classified-listing-store" ) ?></span>
					<?php endif; ?>
				<?php else: ?>
                    <span class="open-day always">
                        <span class="label"><?php esc_html_e( "Always Open", "classified-listing-store" ) ?></span>
                    </span>
				<?php endif; ?>
				<?php do_action( 'rtcl_after_store_hours_text' ); ?>
            </div>
        </div>
		<?php
	}

	static function store_content_restriction( $content ) {
		if ( is_singular( rtclStore()->post_type ) && rtclStore()->post_type === get_post_type() && in_the_loop() && is_main_query()
		     && StoreFunctions::is_store_expired()
		) {
			ob_start();
			do_action( 'rtcl_single_store_expired_content' );

			return ob_get_clean();
		}

		return $content;

	}

	static function store_is_rtcl( $rtcl ) {
		if ( StoreFunctions::is_store() || StoreFunctions::is_single_store() || StoreFunctions::is_store_taxonomy() ) {
			return true;
		}

		return $rtcl;

	}


	/**
	 * Adds extra post classes for listings via the WordPress post_class hook, if used.
	 *
	 * Note: For performance reasons we instead recommend using listing_class/get_listing_class instead.
	 *
	 * @param array        $classes Current classes.
	 * @param string|array $class   Additional class.
	 * @param int          $post_id Post ID.
	 *
	 * @return array
	 * @since 1.3.21
	 */
	static function store_post_class( $classes, $class = '', $post_id = 0 ) {
		if ( ! $post_id || rtclStore()->post_type !== get_post_type( $post_id ) ) {
			return $classes;
		}

		$store = rtclStore()->factory->get_store( $post_id );

		if ( ! $store ) {
			return $classes;
		}
		$classes[] = 'rtcl-store-item';

		return $classes;
	}

	static function get_store_sidebar() {
		RtclFunctions::get_template( 'store/sidebar', null, '', rtclStore()->get_plugin_template_path() );
	}


	public static function add_membership_pricing_options_at_checkout_form( $type ) {
		if ( 'membership' === $type ) {
			$pricing_options = get_posts( apply_filters( 'rtcl_store_membership_pricing_query_args', [
				'post_type'        => rtcl()->post_type_pricing,
				'post_status'      => 'publish',
				'posts_per_page'   => - 1,
				'orderby'          => 'menu_order',
				'order'            => 'ASC',
				'no_found_rows'    => true,
				'meta_query'       => [
					[
						'key'   => 'pricing_type',
						'value' => 'membership',
					]
				],
				'suppress_filters' => false
			] ) );
			Functions::get_template( "checkout/membership", [
				'pricing_options' => $pricing_options
			], '', rtclStore()->get_plugin_template_path() );
		}
	}

	/**
	 * @param WP_User $current_user
	 */
	public static function store_manager_action( $current_user ) {
		if ( is_a( $current_user, WP_User::class ) && $store = StoreFunctions::get_manager_store( $current_user->ID ) ) {
			Functions::get_template( 'myaccount/store-manager-action', compact( 'store', 'current_user' ), '', rtclStore()->get_plugin_template_path() );
		}

	}

	public static function membership_statistic_report( $current_user ) {
		Functions::get_template( 'myaccount/membership-statistic', compact( 'current_user' ), '', rtclStore()->get_plugin_template_path() );
	}


	static function membership_endpoint_content( $type, $value ) {
		Checkout::checkout_form( $type, $value );
	}

	public static function account_store_endpoint() {

		if ( RtclFunctions::get_option_item( 'rtcl_membership_settings', 'enable_store_only_membership', false, 'checkbox' ) ) {
			$member = rtclStore()->factory->get_membership();
			if ( ! $member || $member->is_expired() ) {
				$denied_message = sprintf( '<p class="rtcl-store-access-denied">'
				                           . __( "You have no membership to access this page. You can buy a membership from <a href='%s'>here</a>.",
						"classified-listing-store" ) . '</p>', Link::get_checkout_endpoint_url( 'membership' ) );
				echo apply_filters( 'rtcl_store_access_denied_message', $denied_message );

				return;
			}
		}

		$getStore = get_posts( [
			'post_type'        => rtclStore()->post_type,
			'posts_per_page'   => 1,
			'post_status'      => [ 'publish', 'pending' ],
			'suppress_filters' => false,
			'meta_query'       => [
				[
					'key'     => 'store_owner_id',
					'value'   => get_current_user_id(),
					'type'    => 'numeric',
					'compare' => '=',
				]
			]
		] );
		$store    = null;
		if ( ! empty( $getStore[0] ) ) {
			$store = new Store( $getStore[0] );
		}

		// Process output
		Functions::get_template( "myaccount/store", compact( 'store' ), '', rtclStore()->get_plugin_template_path() );
	}

	public static function add_store_link_to_user_information( $listing_id ) {
		$listing = rtcl()->factory->get_listing( $listing_id );
		if ( $store = StoreFunctions::get_user_store( $listing->get_owner_id() ) ) {
			Functions::get_template( 'store/store-link-to-user-information', compact( 'listing_id', 'store' ), '', rtclStore()->get_plugin_template_path() );
		}
	}

	/**
	 * @param int        $listing_id
	 * @param array      $promotions
	 * @param Membership $membership
	 */
	public static function add_membership_promotions( $listing_id, $promotions, $membership ) {
		Functions::get_template( 'checkout/membership-promotions', compact( 'membership', 'promotions', 'listing_id' ), '',
			rtclStore()->get_plugin_template_path() );
	}

	public static function add_membership_promotions_heading( $type, $listing_id ) {
		if ( "submission" === $type && $listing_id ) {
			$membership = rtclStore()->factory->get_membership();
			if ( $membership && ! $membership->is_expired() && ! empty( $membership->get_promotions() ) ) {
				echo '<h4 id="rtcl-membership-promotions-heading" class="rtcl-promotions-heading active" data-target=".rtcl-membership-promotions-form-wrap"><span>'
				     . apply_filters( 'rtcl_checkout_membership_promotion_title', __( "Membership Promotions", "classified-listing-store" ) ) . '</span></h4>';
			}
		}
	}

	public static function add_checkout_from_heading( $type, $listing_id ) {
		if ( "submission" === $type && $listing_id ) {
			$membership = rtclStore()->factory->get_membership();
			if ( $membership && ! $membership->is_expired() && ! empty( $membership->get_promotions() ) ) {
				echo '<h4 id="rtcl-regular-promotions-heading" class="rtcl-promotions-heading" data-target="#rtcl-woo-checkout-form"><span>'
				     . apply_filters( 'rtcl_checkout_regular_promotion_title', __( "Regular Promotions", "classified-listing-store" ) ) . '</span></h4>';
			}
		}
	}

	public static function add_membership_promotions_from( $type, $listing_id ) {
		if ( "submission" === $type && $listing_id ) {
			$membership = rtclStore()->factory->get_membership();
			if ( $membership && ! $membership->is_expired() && ! empty( $promotions = $membership->get_promotions() ) ) {
				Functions::get_template( 'checkout/membership-promotions-form', compact( 'membership', 'promotions', 'listing_id' ), '',
					rtclStore()->get_plugin_template_path() );
			}
		}
	}

	static function membership_promotion_form_submit_button() {
		?>
        <div class="rtcl-membership-promotion-actions">
            <a class="rtcl-btn rtcl-btn-primary"
               href="<?php echo esc_url( Link::get_my_account_page_link() ) ?>"><?php echo apply_filters( 'rtcl_checkout_myaccount_btn_text',
					__( 'Go to My Account', 'classified-listing-store' ) ); ?></a>
            <button type="submit" id="rtcl-membership-promotion-action" name="_rtcl_membership_promotions_submit"
                    class="rtcl-btn rtcl-btn-primary"
                    value="1"><?php echo apply_filters( 'rtcl_checkout_promotion_btn_text',
					__( 'Proceed to promotion', 'classified-listing-store' ) ); ?></button>
        </div>
		<?php
	}

	/**
	 * @param int $listing_id
	 */
	public static function add_membership_promotions_hidden_field( $listing_id ) {
		wp_nonce_field( 'rtcl_membership_promotions', 'rtcl_membership_promotions_nonce' );
		printf( '<input type="hidden" name="listing_id" value="%d"/>', absint( $listing_id ) );
	}
}
