<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.5.4
 */

if ( ! isset( $content_width ) ) {
	$content_width = 1240;
}

class Classima_Main {

	public $theme = 'classima';
	public $action = 'classima_theme_init';

	public function __construct() {
		//$this->includes();
		add_action( 'after_setup_theme', array( $this, 'includes' ), 5 );
		add_action( 'init', array( $this, 'load_textdomain' ), 20 );
	}

	public function load_textdomain() {
		load_theme_textdomain( $this->theme, get_template_directory() . '/languages' );
	}

	public function includes() {
		require_once get_template_directory() . '/inc/constants.php';
		require_once get_template_directory() . '/inc/helper.php';
		require_once get_template_directory() . '/inc/includes.php';

		do_action( $this->action );
	}
}

new Classima_Main;