<?php
/**
 * Theme Demo Configuration File
 *
 * This file contains the configuration for the demo importer.
 *
 * @package @package Radiustheme\CL_Classified_Core
 */

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

return [
	// Basic theme information.
	'blog_slug'            => 'blog',
	'demo_url'             => 'https://www.radiustheme.com/demo/wordpress/themes/classima/',
	'menus'                => [ 'primary' => 'Main Menu' ],

	// File paths.
	'demo_content_zip'     => 'demo-files/demo-content.zip',

	// Demo variants.
	'demo_variants'        => [
		'home-1'  => [
			'name'    => 'Home 1',
			'preview' => plugins_url( 'screenshots/screenshot1.png', dirname( __FILE__ ) ),
			'url'     => '',
		],
		'home-2'  => [
			'name'    => 'Home 2',
			'preview' => plugins_url( 'screenshots/screenshot2.png', dirname( __FILE__ ) ),
			'url'     => 'home-2',
		],
		'home-3'  => [
			'name'    => 'Home 3',
			'preview' => plugins_url( 'screenshots/screenshot3.png', dirname( __FILE__ ) ),
			'url'     => 'home-3',
		],
		'home-4'  => [
			'name'    => 'Home 4',
			'preview' => plugins_url( 'screenshots/screenshot4.png', dirname( __FILE__ ) ),
			'url'     => 'home-4',
		],
		'home-5'  => [
			'name'    => 'Home 5',
			'preview' => plugins_url( 'screenshots/screenshot5.png', dirname( __FILE__ ) ),
			'url'     => 'home-5',
		],
		'home-6'  => [
			'name'    => 'Home 6',
			'preview' => plugins_url( 'screenshots/screenshot6.png', dirname( __FILE__ ) ),
			'url'     => 'home-6',
		],
		'home-7'  => [
			'name'    => 'Home 7',
			'preview' => plugins_url( 'screenshots/screenshot7.png', dirname( __FILE__ ) ),
			'url'     => 'home-7',
		],
		'home-8'  => [
			'name'    => 'Home 8',
			'preview' => plugins_url( 'screenshots/screenshot8.png', dirname( __FILE__ ) ),
			'url'     => 'home-8',
		],
		'home-9'  => [
			'name'    => 'Home 9',
			'preview' => plugins_url( 'screenshots/screenshot9.png', dirname( __FILE__ ) ),
			'url'     => 'home-9',
		],
		'home-10' => [
			'name'    => 'Home 10',
			'preview' => plugins_url( 'screenshots/screenshot10.png', dirname( __FILE__ ) ),
			'url'     => 'home-10',
		],
		'home-11' => [
			'name'    => 'Home 11',
			'preview' => plugins_url( 'screenshots/screenshot11.png', dirname( __FILE__ ) ),
			'url'     => 'home-11',
		],
		'home-12' => [
			'name'    => 'Home 12',
			'preview' => plugins_url( 'screenshots/screenshot12.png', dirname( __FILE__ ) ),
			'url'     => 'home-12',
		],
	],

	// Additional settings.
	'settings_json'        => [
		'rtcl_filter_settings',
		'classima',
		'classima_ads',
	],

	// WordPress repository plugins.
	'wp_plugins'           => [
		'classified-listing'          => 'Classified Listing – Classified ads & Business Directory Plugin',
		'classified-listing-toolkits' => 'Classified Listing Toolkits',
		'elementor'                   => 'Elementor Page Builder',
		'review-schema'               => 'Review Schema',
		'contact-form-7'              => [
			'name' => 'Contact Form 7',
			'file' => 'contact-form-7/wp-contact-form-7.php',
		],
	],

	// Bundled/Premium plugins.
	'bundled_plugins'      => [
		'rt-framework'             => [
			'name' => 'RT Framework',
			'file' => 'plugin-bundle/rt-framework.zip',
		],
		'classified-listing-pro'   => [
			'name' => 'Classified Listing Pro',
			'file' => 'plugin-bundle/classified-listing-pro.zip',
		],
		'classified-listing-store' => [
			'name' => 'Classified Listing Store',
			'file' => 'plugin-bundle/classified-listing-store.zip',
		],
		'review-schema-pro'        => [
			'name' => 'Review Schema Pro',
			'file' => 'plugin-bundle/review-schema-pro.zip',
		],
	],

	// Enable/disable import features.
	'features'             => [
		'rtcl_support'    => true,
		'elementor_fixes' => true
	],

	// Elementor data fixes.
	'elementor_fixes'      => [
		'rt-listing-category-box'      => [ 'listing_cat_id' ],
		'rt-listing-cat-box'           => [ 'cats' ],
		'rt-listing-cat-list'          => [ 'cats', 'top_cats_list' ],
		'rt-listing-cat-slider'        => [ 'cats' ],
		'rtcl-listing-single-location' => [ 'location' ],
		'rt-listing-location-box'      => [ 'location' ],
		'rt-listing-location-box-2'    => [ 'location' ],
		'rt-listing-locations-grid'    => [ 'repeater_items' => 'listing_loc_id' ],
		'rt-listing-grid'              => [ 'cat', 'exclude_cat' ],
		'rt-listing-list'              => [ 'cat', 'exclude_cat' ],
		'rt-listing-isotope'           => [ 'cat', 'exclude_cat' ],
		'rt-listing-slider'            => [ 'cat', 'exclude_cat' ],
		'rtcl-listing-category-slider' => [ 'rtcl_cats' ],
	],

	// RTCL Pages to remove before import.
	'rtcl_pages_to_remove' => [
		'Listings',
		'Listing Form',
		'My Account',
		'Checkout',
	],

	// RTCL pages to create/update.
	'rtcl_pages'           => [
		'listings'     => 'All Ads',
		'listing_form' => 'Post an Ad',
		'myaccount'    => 'My Account',
		'checkout'     => 'Checkout',
		'compare'      => 'Compare Page',
		'store'        => 'Store',
	],

	// Pre-import options.
	'pre_import_options'   => [
		'elementor_experiment-e_font_icon_svg' => 'inactive',
		'elementor_experiment-container'       => 'inactive',
		'elementor_experiment-nested-elements' => 'inactive',
		'elementor_font_display'               => 'swap',
		'elementor_load_fa4_shim'              => 'yes',
	],

	// Post-import options.
	'post_import_options'  => [
		'elementor_allow_unfiltered_files' => true,
	],

	// Custom RTCL import files.
	'rtcl_custom_files'    => [
		'rtcl_options' => 'demo-files/rtcl-settings.json',
		'rtcl_forms'   => 'demo-files/rtclform.json',
	],
];
