(function ($) {
    "use strict";

    /*
    * Call unread messages for chat
    */
    function updateUnreadMessages() {
        const unread_wrap = $('.rtcl-chat-unread-count');
        if (unread_wrap.length !== 0) {
            $.ajax({
                url: rtcl.ajaxurl,
                method: 'GET',
                data: {
                    action: 'rtcl_chat_ajax_get_unread_message_num'
                },
                success: function (response) {
                    unread_wrap.find('.rtcl-unread-badge').remove();
                    const count = parseInt(response, 10) || 0;
                    if (count) {
                        const badge = $('<span class="rtcl-unread-badge"></span>');
                        badge.text(count);
                        unread_wrap.append(badge);
                    }
                },
                complete: function () {
                    setTimeout(updateUnreadMessages, 5000);
                }
            });
        }
    }

    $(function () {
        updateUnreadMessages();
    });


})(jQuery);