<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Classima_Core;

use radiustheme\Classima\Helper;
use radiustheme\Classima\RDTheme;
use Rtcl\Helpers\Functions;

$keyword = isset( $_GET['q'] ) ? esc_attr( $_GET['q'] ) : '';
$class   = "rtin-{$data['theme']} rtin-style-{$data['style']}";
$style   = RDTheme::$options['listing_search_style'];
?>
<div class="rt-el-listing-search rtcl <?php echo esc_attr( $class ); ?>">
	<?php
	if ( $data['style'] == '3' ) {
		require_once 'search-banner.php';
	} else {
		?>
        <div class="rtcl rtcl-search rtcl-search-inline classima-listing-search">
            <form action="<?php echo esc_url( Functions::get_filter_form_url() ); ?>"
                  class="form-vertical rtcl-widget-search-form rtcl-search-inline-form classima-listing-search-form rtin-style-<?php echo esc_attr( $style ); ?>">
				<?php Helper::get_custom_listing_template( 'listing-search' ); ?>
            </form>
        </div>
	<?php } ?>
</div>